/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.logging;

import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public final class ClasspathLoggingApplicationListener
implements GenericApplicationListener {
    private static final int ORDER = -2147483627;
    private static final Log logger = LogFactory.getLog(ClasspathLoggingApplicationListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (logger.isDebugEnabled()) {
            if (event instanceof ApplicationEnvironmentPreparedEvent) {
                logger.debug((Object)("Application started with classpath: " + this.getClasspath()));
            } else if (event instanceof ApplicationFailedEvent) {
                logger.debug((Object)("Application failed to start with classpath: " + this.getClasspath()));
            }
        }
    }

    public int getOrder() {
        return -2147483627;
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        Class type = resolvableType.getRawClass();
        if (type == null) {
            return false;
        }
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(type) || ApplicationFailedEvent.class.isAssignableFrom(type);
    }

    private String getClasspath() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof URLClassLoader) {
            return Arrays.toString(((URLClassLoader)classLoader).getURLs());
        }
        return "unknown";
    }
}

