/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import java.io.Closeable;
import java.util.function.Consumer;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.watch.NodeEvent;
import org.apache.hugegraph.pd.watch.PartitionEvent;

public interface PDWatch {
    public static <T> Listener<T> listener(Consumer<T> onNext) {
        return PDWatch.listener(onNext, t -> {}, () -> {});
    }

    public static <T> Listener<T> listener(Consumer<T> onNext, Consumer<Throwable> onError) {
        return PDWatch.listener(onNext, onError, () -> {});
    }

    public static <T> Listener<T> listener(Consumer<T> onNext, Runnable onCompleted) {
        return PDWatch.listener(onNext, t -> {}, onCompleted);
    }

    public static <T> Listener<T> listener(final Consumer<T> onNext, final Consumer<Throwable> onError, final Runnable onCompleted) {
        return new Listener<T>(){

            @Override
            public void onNext(T response) {
                onNext.accept(response);
            }

            @Override
            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            @Override
            public void onCompleted() {
                onCompleted.run();
            }
        };
    }

    public String getCurrentHost();

    public boolean checkChannel();

    public Watcher watchPartition(Listener<PartitionEvent> var1);

    public Watcher watchNode(Listener<NodeEvent> var1);

    public Watcher watchGraph(Listener<WatchResponse> var1);

    public Watcher watchShardGroup(Listener<WatchResponse> var1);

    public static interface Watcher
    extends Closeable {
        @Override
        public void close();
    }

    public static interface Listener<T> {
        public void onNext(T var1);

        public void onError(Throwable var1);

        default public void onCompleted() {
        }
    }
}

