/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.graph.Shard;
import org.apache.hugegraph.structure.graph.Vertices;
import org.apache.hugegraph.util.E;

public class VariablesAPI
extends TraversersAPI {
    public VariablesAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "variables";
    }

    public List<Shard> shards(long splitSize) {
        String path = String.join((CharSequence)"/", this.path(), "shards");
        ImmutableMap params = ImmutableMap.of((Object)"split_size", (Object)splitSize);
        RestResult result = this.client.get(path, (Map<String, Object>)params);
        return result.readList("shards", Shard.class);
    }

    public Vertices scan(Shard shard, String page, long pageLimit) {
        E.checkArgument((shard != null ? 1 : 0) != 0, (String)"Shard can't be null", (Object[])new Object[0]);
        String path = String.join((CharSequence)"/", this.path(), "scan");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("start", shard.start());
        params.put("end", shard.end());
        params.put("page", page);
        params.put("page_limit", pageLimit);
        RestResult result = this.client.get(path, params);
        return (Vertices)result.readObject(Vertices.class);
    }
}

