/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotZnode
implements Closeable {
    static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(SlotZnode.class);
    private final AtomicReference<CountDownLatch> initialCreateLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final AtomicReference<String> nodePath = new AtomicReference<Object>(null);
    private final Random rdm = new Random();
    private final CuratorFramework client;
    private final String basePath;
    private final String prefix;
    private final String workerPrefix;
    private final String dataStr;
    private final byte[] data;
    private int currentSlot;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private int fallbackCount = 0;
    private final BackgroundCallback backgroundCallback = new BackgroundCallback(){

        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            SlotZnode.this.processCreateResult(client, event);
        }
    };
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            SlotZnode.this.processWatchedEvent(event);
        }
    };
    private final BackgroundCallback checkExistsCallback = new BackgroundCallback(){

        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            SlotZnode.this.processWatchResult(event);
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            SlotZnode.this.processConnectionState(newState);
        }
    };

    public SlotZnode(CuratorFramework client, String basePath, String prefix, String workerPrefix, String data) {
        this.client = Preconditions.checkNotNull(client, "client cannot be null");
        this.basePath = Preconditions.checkNotNull(basePath, "basePath cannot be null");
        this.prefix = Preconditions.checkNotNull(prefix, "prefix cannot be null");
        this.workerPrefix = workerPrefix;
        Preconditions.checkNotNull(data, "data cannot be null");
        this.dataStr = data;
        this.data = data.getBytes(CHARSET);
    }

    @VisibleForTesting
    public int getFallbackCount() {
        return this.fallbackCount;
    }

    private void chooseSlotToTake() throws Exception {
        int slotToTake = -1;
        while (true) {
            int nextTaken;
            List allChildNodes;
            try {
                allChildNodes = (List)this.client.getChildren().forPath(this.basePath);
            }
            catch (Exception e) {
                LOG.error("Cannot list nodes to get slots; failing", (Throwable)e);
                throw e;
            }
            TreeSet<Integer> slots = new TreeSet<Integer>();
            int approxWorkerCount = 0;
            for (String child : allChildNodes) {
                if (!child.startsWith(this.prefix)) {
                    if (!child.startsWith(this.workerPrefix)) continue;
                    ++approxWorkerCount;
                    continue;
                }
                slots.add(Integer.parseInt(child.substring(this.prefix.length())));
            }
            Iterator slotIter = slots.iterator();
            slotToTake = 0;
            while (slotIter.hasNext() && slotToTake >= (nextTaken = ((Integer)slotIter.next()).intValue())) {
                slotToTake = nextTaken + 1;
            }
            if (slotToTake != this.currentSlot || !this.shouldFallBackOnCollision(approxWorkerCount)) break;
            ++this.fallbackCount;
            Thread.sleep(this.rdm.nextInt(200));
        }
        this.currentSlot = slotToTake;
        LOG.info("Will attempt to take slot " + this.currentSlot);
    }

    private boolean shouldFallBackOnCollision(int approxWorkerCount) {
        if (approxWorkerCount == 0) {
            return false;
        }
        return (double)(2.0f / (float)approxWorkerCount) <= this.rdm.nextDouble();
    }

    private String getSlotPath(int slot) {
        return String.format("%s/%s%010d", this.basePath, this.prefix, slot);
    }

    public boolean start(long timeout, TimeUnit unit) throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.INITIAL_SELECTION), "Already started");
        CountDownLatch localLatch = this.initialCreateLatch.get();
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.chooseSlotToTake();
        this.startCreateCurrentNode();
        return localLatch.await(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        State currentState = this.state.getAndSet(State.CLOSED);
        if (currentState == State.CLOSED || currentState == State.LATENT) {
            return;
        }
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath == null) {
            return;
        }
        try {
            this.client.delete().guaranteed().forPath(localNodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            LOG.error("Deleting node: " + localNodePath, (Throwable)e);
            throw new IOException(e);
        }
    }

    public int getCurrentSlot() {
        assert (this.isActive());
        return this.currentSlot;
    }

    private void startCreateCurrentNode() {
        if (!this.isActive()) {
            return;
        }
        String createPath = null;
        try {
            createPath = this.getSlotPath(this.currentSlot);
            LOG.info("Attempting to create " + createPath);
            ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).inBackground(this.backgroundCallback)).forPath(createPath, this.data);
        }
        catch (Exception e) {
            LOG.error("Creating node. Path: " + createPath, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void watchNode() throws Exception {
        if (!this.isActive()) {
            return;
        }
        String localNodePath = this.nodePath.get();
        if (localNodePath == null) {
            return;
        }
        try {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.checkExistsCallback)).forPath(localNodePath);
        }
        catch (Exception e) {
            LOG.error("Watching node: " + localNodePath, (Throwable)e);
            throw e;
        }
    }

    private boolean isActive() {
        State localState = this.state.get();
        return localState != State.LATENT && localState != State.CLOSED;
    }

    private void processWatchResult(CuratorEvent event) throws Exception {
        if (event.getResultCode() != KeeperException.Code.NONODE.intValue()) {
            return;
        }
        LOG.info("Trying to reacquire because of the NONODE event");
        this.startCreateCurrentNode();
    }

    private void processConnectionState(ConnectionState newState) {
        if (newState != ConnectionState.RECONNECTED) {
            return;
        }
        LOG.info("Trying to reacquire because of the RECONNECTED event");
        this.startCreateCurrentNode();
    }

    private void processWatchedEvent(WatchedEvent event) {
        if (event.getType() != Watcher.Event.EventType.NodeDeleted) {
            return;
        }
        String localPath = this.nodePath.get();
        if (localPath == null) {
            return;
        }
        if (!localPath.equals(event.getPath())) {
            LOG.info("Ignoring the NodeDeleted event for " + event.getPath());
            return;
        }
        LOG.info("Trying to reacquire because of the NodeDeleted event");
        this.startCreateCurrentNode();
    }

    private void processCreateResult(CuratorFramework client, CuratorEvent event) throws Exception {
        boolean doesExist;
        boolean bl = doesExist = event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue();
        if (!doesExist && event.getResultCode() != KeeperException.Code.OK.intValue()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Trying to reacquire due to create error: " + event);
            }
            this.startCreateCurrentNode();
            return;
        }
        State localState = this.state.get();
        switch (localState) {
            case CLOSED: 
            case LATENT: {
                return;
            }
            case INITIAL_SELECTION: {
                if (doesExist) {
                    LOG.info("Slot " + this.currentSlot + " was occupied");
                    this.chooseSlotToTake();
                    this.startCreateCurrentNode();
                    break;
                }
                this.handleCreatedNode(event.getName());
                break;
            }
            case AFTER_SELECTION: {
                if (doesExist) {
                    this.processExistsFromCreate(client, event.getPath());
                    break;
                }
                this.handleCreatedNode(event.getName());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown state " + (Object)((Object)localState)));
            }
        }
    }

    private void processExistsFromCreate(CuratorFramework client, String path) throws Exception {
        byte[] actual;
        try {
            actual = (byte[])client.getData().forPath(path);
        }
        catch (Exception ex) {
            LOG.error("Error getting data for the node; will retry creating", (Throwable)ex);
            this.startCreateCurrentNode();
            return;
        }
        if (Arrays.equals(actual, this.data)) {
            this.handleCreatedNode(path);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Data at {} is from a different node: {} (we are {})", new Object[]{path, new String(actual, CHARSET), this.dataStr});
            }
            this.nodePath.getAndSet(null);
            this.chooseSlotToTake();
            this.startCreateCurrentNode();
        }
    }

    private void handleCreatedNode(String path) throws Exception {
        State localState;
        do {
            if ((localState = this.state.get()) != State.CLOSED && localState != State.LATENT) continue;
            return;
        } while (!this.state.compareAndSet(localState, State.AFTER_SELECTION));
        this.nodePath.set(path);
        this.watchNode();
        CountDownLatch localLatch = this.initialCreateLatch.getAndSet(null);
        if (localLatch != null) {
            localLatch.countDown();
        }
        LOG.info("Acquired the slot znode {}{}", (Object)path, (Object)(localLatch != null ? "; this is the initial assignment" : ""));
    }

    @VisibleForTesting
    public String getActualPath() {
        return this.nodePath.get();
    }

    private static enum State {
        LATENT,
        INITIAL_SELECTION,
        AFTER_SELECTION,
        CLOSED;

    }
}

