/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import java.util.Date;
import kotlin.Pair;
import okhttp3.Headers;

public class RestHeaders {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String AUTHORIZATION = "Authorization";
    public static final String APPLICATION_JSON = "application/json";
    public static final String BEARER_PREFIX = "Bearer ";
    private final Headers.Builder headersBuilder = new Headers.Builder();

    public static RestHeaders convertToRestHeaders(Headers headers) {
        RestHeaders restHeaders = new RestHeaders();
        if (headers != null) {
            for (Pair pair : headers) {
                restHeaders.add((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        return restHeaders;
    }

    public String get(String key) {
        return this.headersBuilder.get(key);
    }

    public Date getDate(String key) {
        return this.headersBuilder.build().getDate(key);
    }

    public RestHeaders add(String key, String value) {
        this.headersBuilder.add(key, value);
        return this;
    }

    public RestHeaders add(String key, Date value) {
        this.headersBuilder.add(key, value);
        return this;
    }

    public int hashCode() {
        return this.toOkHttpHeader().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RestHeaders) {
            return this.toOkHttpHeader().equals((Object)((RestHeaders)obj).toOkHttpHeader());
        }
        return false;
    }

    public Headers toOkHttpHeader() {
        return this.headersBuilder.build();
    }
}

