/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.common.GraphCache;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCache {
    private static final Logger log = LoggerFactory.getLogger(ClientCache.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final PDClient client;
    private volatile Map<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>> groups;
    private volatile Map<Long, Metapb.Store> stores;
    private volatile Map<String, GraphCache> caches = new ConcurrentHashMap<String, GraphCache>();

    public ClientCache(PDClient pdClient) {
        this.groups = new ConcurrentHashMap<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>>();
        this.stores = new ConcurrentHashMap<Long, Metapb.Store>();
        this.client = pdClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphCache getGraphCache(String graphName) {
        GraphCache graph = this.caches.get(graphName);
        if (graph == null) {
            Map<String, GraphCache> map = this.caches;
            synchronized (map) {
                graph = this.caches.get(graphName);
                if (graph == null) {
                    graph = new GraphCache();
                    this.caches.put(graphName, graph);
                }
            }
        }
        return graph;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionById(String graphName, int partId) {
        try {
            GraphCache graph = this.initGraph(graphName);
            Metapb.Partition partition = graph.getPartition(Integer.valueOf(partId));
            if (partition == null) {
                return null;
            }
            KVPair<Metapb.ShardGroup, Metapb.Shard> group = this.groups.get(partId);
            if (group == null) {
                return null;
            }
            Metapb.Shard shard = (Metapb.Shard)group.getValue();
            if (shard == null) {
                return null;
            }
            return new KVPair((Object)partition, (Object)shard);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KVPair<Metapb.Partition, Metapb.Shard> getPair(int partId, GraphCache graph) {
        Metapb.Partition p = graph.getPartition(Integer.valueOf(partId));
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partId);
        if (p != null && pair != null) {
            Metapb.Shard s = (Metapb.Shard)pair.getValue();
            if (s == null) {
                pair.setValue((Object)this.getLeader(partId));
                return new KVPair((Object)p, (Object)((Metapb.Shard)pair.getValue()));
            }
            return new KVPair((Object)p, (Object)s);
        }
        return null;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByCode(String graphName, long code) {
        try {
            GraphCache graph = this.initGraph(graphName);
            RangeMap range = graph.getRange();
            Integer pId = (Integer)range.get((Comparable)Long.valueOf(code));
            if (pId != null) {
                return this.getPair(pId, graph);
            }
            return null;
        }
        catch (PDException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphCache initGraph(String graphName) throws PDException {
        this.initCache();
        GraphCache graph = this.getGraphCache(graphName);
        if (!graph.getInitialized().get()) {
            GraphCache graphCache = graph;
            synchronized (graphCache) {
                if (!graph.getInitialized().get()) {
                    Pdpb.CachePartitionResponse pc = this.client.getPartitionCache(graphName);
                    RangeMap range = graph.getRange();
                    List ps = pc.getPartitionsList();
                    HashMap<Integer, Metapb.Partition> gps = new HashMap<Integer, Metapb.Partition>(ps.size(), 1.0f);
                    for (Metapb.Partition p : ps) {
                        gps.put(p.getId(), p);
                        range.put(Range.closedOpen((Comparable)Long.valueOf(p.getStartKey()), (Comparable)Long.valueOf(p.getEndKey())), (Object)p.getId());
                    }
                    graph.setPartitions(gps);
                    graph.getInitialized().set(true);
                }
            }
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache() throws PDException {
        if (!this.initialized.get()) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                if (!this.initialized.get()) {
                    Pdpb.CacheResponse cache = this.client.getClientCache();
                    List shardGroups = cache.getShardsList();
                    for (Object s : shardGroups) {
                        this.groups.put(s.getId(), (KVPair<Metapb.ShardGroup, Metapb.Shard>)new KVPair(s, (Object)this.getLeader(s.getId())));
                    }
                    List stores = cache.getStoresList();
                    for (Metapb.Store store : stores) {
                        this.stores.put(store.getId(), store);
                    }
                    List graphs = cache.getGraphsList();
                    for (Metapb.Graph g : graphs) {
                        GraphCache c = new GraphCache(g);
                        this.caches.put(g.getGraphName(), c);
                    }
                    this.initialized.set(true);
                }
            }
        }
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByKey(String graphName, byte[] key) {
        int code = PartitionUtils.calcHashcode((byte[])key);
        return this.getPartitionByCode(graphName, code);
    }

    public boolean update(String graphName, int partId, Metapb.Partition partition) {
        GraphCache graph = this.getGraphCache(graphName);
        try {
            Metapb.Partition p = graph.getPartition(Integer.valueOf(partId));
            if (p != null && p.equals((Object)partition)) {
                return false;
            }
            RangeMap range = graph.getRange();
            graph.addPartition(Integer.valueOf(partId), partition);
            if (p != null && Objects.equals(partition.getId(), range.get((Comparable)Long.valueOf(partition.getStartKey()))) && Objects.equals(partition.getId(), range.get((Comparable)Long.valueOf(partition.getEndKey() - 1L)))) {
                range.remove((Range)range.getEntry((Comparable)Long.valueOf(partition.getStartKey())).getKey());
            }
            range.put(Range.closedOpen((Comparable)Long.valueOf(partition.getStartKey()), (Comparable)Long.valueOf(partition.getEndKey())), (Object)partId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void removePartition(String graphName, int partId) {
        GraphCache graph = this.getGraphCache(graphName);
        Metapb.Partition p = graph.removePartition(Integer.valueOf(partId));
        if (p != null) {
            RangeMap range = graph.getRange();
            if (Objects.equals(p.getId(), range.get((Comparable)Long.valueOf(p.getStartKey()))) && Objects.equals(p.getId(), range.get((Comparable)Long.valueOf(p.getEndKey() - 1L)))) {
                range.remove((Range)range.getEntry((Comparable)Long.valueOf(p.getStartKey())).getKey());
            }
        }
    }

    public void removePartitions() {
        for (Map.Entry<String, GraphCache> entry : this.caches.entrySet()) {
            this.removePartitions(entry.getValue());
        }
    }

    private void removePartitions(GraphCache graph) {
        graph.getState().clear();
        graph.getRange().clear();
    }

    public void removeAll(String graphName) {
        GraphCache graph = this.caches.get(graphName);
        if (graph != null) {
            this.removePartitions(graph);
        }
    }

    public boolean updateShardGroup(Metapb.ShardGroup shardGroup) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> old = this.groups.get(shardGroup.getId());
        Metapb.Shard leader = this.getLeader(shardGroup);
        if (old != null) {
            old.setKey((Object)shardGroup);
            old.setValue((Object)leader);
            return false;
        }
        this.groups.put(shardGroup.getId(), (KVPair<Metapb.ShardGroup, Metapb.Shard>)new KVPair((Object)shardGroup, (Object)leader));
        return true;
    }

    public void deleteShardGroup(int shardGroupId) {
        this.groups.remove(shardGroupId);
    }

    public Metapb.ShardGroup getShardGroup(int groupId) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(groupId);
        if (pair != null) {
            return (Metapb.ShardGroup)pair.getKey();
        }
        return null;
    }

    public boolean addStore(Long storeId, Metapb.Store store) {
        Metapb.Store oldStore = this.stores.get(storeId);
        if (oldStore != null && oldStore.equals((Object)store)) {
            return false;
        }
        this.stores.put(storeId, store);
        return true;
    }

    public Metapb.Store getStoreById(Long storeId) {
        return this.stores.get(storeId);
    }

    public void removeStore(Long storeId) {
        this.stores.remove(storeId);
    }

    public void reset() {
        this.groups = new ConcurrentHashMap<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>>();
        this.stores = new ConcurrentHashMap<Long, Metapb.Store>();
        this.caches = new ConcurrentHashMap<String, GraphCache>();
        this.initialized.set(false);
    }

    public Metapb.Shard getLeader(int partitionId) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partitionId);
        if (pair != null) {
            if (pair.getValue() != null) {
                return (Metapb.Shard)pair.getValue();
            }
            for (Metapb.Shard shard : ((Metapb.ShardGroup)pair.getKey()).getShardsList()) {
                if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                pair.setValue((Object)shard);
                return shard;
            }
        }
        return null;
    }

    public Metapb.Shard getLeader(Metapb.ShardGroup shardGroup) {
        if (shardGroup != null) {
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                return shard;
            }
        }
        return null;
    }

    public void updateLeader(int partitionId, Metapb.Shard leader) {
        Metapb.Shard l;
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partitionId);
        if (pair != null && leader != null && ((l = this.getLeader(partitionId)) == null || leader.getStoreId() != l.getStoreId())) {
            Metapb.ShardGroup shardGroup = (Metapb.ShardGroup)pair.getKey();
            Metapb.ShardGroup.Builder builder = Metapb.ShardGroup.newBuilder((Metapb.ShardGroup)shardGroup).clearShards();
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                builder.addShards(Metapb.Shard.newBuilder().setStoreId(shard.getStoreId()).setRole(shard.getStoreId() == leader.getStoreId() ? Metapb.ShardRole.Leader : Metapb.ShardRole.Follower).build());
            }
            pair.setKey((Object)builder.build());
            pair.setValue((Object)leader);
        }
    }
}

