/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;

public class MemoryManagerImpl
implements MemoryManager {
    private final long totalMemoryPool;
    private final Map<Path, WriterInfo> writerList = new HashMap<Path, WriterInfo>();
    private final AtomicLong totalAllocation = new AtomicLong(0L);

    public MemoryManagerImpl(Configuration conf) {
        this(Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * OrcConf.MEMORY_POOL.getDouble(conf)));
    }

    public MemoryManagerImpl(long poolSize) {
        this.totalMemoryPool = poolSize;
    }

    @Override
    public synchronized void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) throws IOException {
        WriterInfo oldVal = this.writerList.get(path);
        if (oldVal == null) {
            oldVal = new WriterInfo(requestedAllocation);
            this.writerList.put(path, oldVal);
            this.totalAllocation.addAndGet(requestedAllocation);
        } else {
            this.totalAllocation.addAndGet(requestedAllocation - oldVal.allocation);
            oldVal.allocation = requestedAllocation;
        }
    }

    @Override
    public synchronized void removeWriter(Path path) throws IOException {
        WriterInfo val = this.writerList.get(path);
        if (val != null) {
            this.writerList.remove(path);
            this.totalAllocation.addAndGet(-val.allocation);
        }
    }

    public long getTotalMemoryPool() {
        return this.totalMemoryPool;
    }

    public double getAllocationScale() {
        long alloc = this.totalAllocation.get();
        return alloc <= this.totalMemoryPool ? 1.0 : (double)this.totalMemoryPool / (double)alloc;
    }

    @Override
    public void addedRow(int rows) throws IOException {
    }

    public void notifyWriters() throws IOException {
    }

    @Override
    public long checkMemory(long previous, MemoryManager.Callback writer) throws IOException {
        long current = this.totalAllocation.get();
        if (current != previous) {
            writer.checkMemory(this.getAllocationScale());
        }
        return current;
    }

    private static class WriterInfo {
        long allocation;

        WriterInfo(long allocation) {
            this.allocation = allocation;
        }
    }
}

