/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcherKeyValuePair;
import org.simpleflatmapper.util.Asserts;

public final class DefaultPropertyNameMatcher
implements PropertyNameMatcher {
    private final String column;
    private final int from;
    private final boolean exactMatch;
    private final boolean caseSensitive;
    private final int effectiveEndIndex;

    public DefaultPropertyNameMatcher(String column, int from, boolean exactMatch, boolean caseSensitive) {
        if (from > column.length()) {
            throw new IndexOutOfBoundsException("Index " + from + " out of " + column.length());
        }
        this.column = (String)Asserts.requireNonNull((String)"property", (Object)column);
        this.from = from;
        this.exactMatch = exactMatch;
        this.caseSensitive = caseSensitive;
        this.effectiveEndIndex = this.lastNonIgnorableChar(column) + 1;
    }

    @Override
    public PropertyNameMatch matches(CharSequence property) {
        return this.matches(property, false);
    }

    @Override
    public PropertyNameMatch matches(CharSequence property, boolean tryPlural) {
        if (property == null) {
            return null;
        }
        int endIndex = this._partialMatch(property, tryPlural);
        if (endIndex == this.effectiveEndIndex) {
            int meaningfulCharColumn;
            int meaningfulCharProperty = this.meaningfulChar(property, 0, property.length());
            int score = meaningfulCharColumn = this.meaningfulChar(this.column, this.from, endIndex);
            int skippedLetters = meaningfulCharProperty - meaningfulCharColumn;
            return new PropertyNameMatch(property.toString(), this.column.substring(this.from, endIndex), null, score, skippedLetters);
        }
        return null;
    }

    @Override
    public PropertyNameMatch partialMatch(CharSequence property) {
        return this.partialMatch(property, false);
    }

    @Override
    public PropertyNameMatch partialMatch(CharSequence property, boolean tryPlural) {
        int index = this._partialMatch(property, tryPlural);
        if (index != -1) {
            int meaningfulCharColumn;
            int meaningfulCharProperty = this.meaningfulChar(property, 0, property.length());
            int score = meaningfulCharColumn = this.meaningfulChar(this.column, this.from, index);
            int skippedLater = meaningfulCharProperty - meaningfulCharColumn;
            return new PropertyNameMatch(property.toString(), this.column.substring(this.from, index), new DefaultPropertyNameMatcher(this.column, index, this.exactMatch, this.caseSensitive), score, skippedLater);
        }
        return null;
    }

    private int lastNonIgnorableChar(String column) {
        for (int i = column.length() - 1; i >= 0; --i) {
            if (DefaultPropertyNameMatcher.isSeparatorChar(column.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    @Override
    public IndexedColumn matchIndex() {
        int listIndexEnd;
        char ch;
        int listIndexStart;
        int index = -1;
        for (listIndexStart = this.from; listIndexStart < this.column.length() && DefaultPropertyNameMatcher.isSeparatorChar(this.column.charAt(listIndexStart)); ++listIndexStart) {
        }
        boolean encounterSeparator = false;
        int effectivePropertyStart = listIndexStart;
        while (listIndexStart < this.column.length() && !Character.isDigit(ch = this.column.charAt(listIndexStart))) {
            if (DefaultPropertyNameMatcher.isSeparatorChar(ch)) {
                encounterSeparator = true;
            } else if (encounterSeparator) {
                return null;
            }
            ++listIndexStart;
        }
        for (listIndexEnd = listIndexStart; listIndexEnd < this.column.length() && Character.isDigit(this.column.charAt(listIndexEnd)); ++listIndexEnd) {
        }
        if (listIndexStart != listIndexEnd) {
            index = Integer.parseInt(this.column.substring(listIndexStart, listIndexEnd));
        }
        if (index == -1) {
            return null;
        }
        DefaultPropertyNameMatcher subPropertyNameMatcher = null;
        if (listIndexEnd < this.column.length()) {
            subPropertyNameMatcher = new DefaultPropertyNameMatcher(this.column, listIndexEnd, this.exactMatch, this.caseSensitive);
        }
        int score = this.meaningfulChar(this.column, effectivePropertyStart, listIndexEnd);
        return new IndexedColumn(index, this.column.substring(listIndexStart, listIndexEnd), subPropertyNameMatcher, score, listIndexStart != effectivePropertyStart || listIndexEnd < this.column.length() && !DefaultPropertyNameMatcher.isSeparatorChar(this.column.charAt(listIndexEnd)));
    }

    private int _partialMatch(CharSequence property, boolean tryPlural) {
        if (property == null) {
            return -1;
        }
        int indexColumn = this.from;
        int indexProperty = 0;
        int nbCharIncommon = 0;
        while (indexProperty < property.length()) {
            char charProperty = property.charAt(indexProperty++);
            boolean skipedIgnorablePropertyCharacter = false;
            while (this.ignoreCharacter(charProperty)) {
                if (indexProperty >= property.length()) {
                    return indexColumn;
                }
                charProperty = property.charAt(indexProperty++);
                skipedIgnorablePropertyCharacter = true;
            }
            if (indexColumn >= this.column.length()) {
                if (nbCharIncommon > 0) {
                    if (this.endOfPropertyWord(charProperty, skipedIgnorablePropertyCharacter)) {
                        return indexColumn;
                    }
                    return this.isPluralEnd(property, indexProperty - 1, this.column, this.from, indexColumn, tryPlural);
                }
                return -1;
            }
            char charColumn = this.column.charAt(indexColumn++);
            boolean skipedIgnorableColumnCharacter = false;
            while (this.ignoreCharacter(charColumn)) {
                if (indexColumn >= this.column.length()) {
                    return -1;
                }
                charColumn = this.column.charAt(indexColumn++);
                skipedIgnorableColumnCharacter = true;
            }
            if (this.caseSensitive && skipedIgnorableColumnCharacter) {
                charColumn = Character.toUpperCase(charColumn);
            }
            if (this.areDifferentCharacters(charProperty, charColumn)) {
                if (nbCharIncommon > 0) {
                    if (skipedIgnorableColumnCharacter && this.endOfPropertyWord(charProperty, skipedIgnorablePropertyCharacter)) {
                        return indexColumn - 2;
                    }
                    return this.isPluralEnd(property, indexProperty - 1, this.column, this.from, indexColumn - 2, tryPlural);
                }
                return -1;
            }
            ++nbCharIncommon;
        }
        return indexColumn;
    }

    private boolean endOfPropertyWord(char charProperty, boolean skipedIgnorablePropertyCharacter) {
        return skipedIgnorablePropertyCharacter || Character.isUpperCase(charProperty);
    }

    private int isPluralEnd(CharSequence property, int indexProperty, CharSequence column, int fromColumn, int indexColumn, boolean tryPlural) {
        if (!tryPlural) {
            return -1;
        }
        return this.isPlural(property, indexProperty, column, fromColumn, indexColumn);
    }

    private int isPlural(CharSequence property, int indexProperty, CharSequence column, int fromColumn, int indexColumn) {
        if (indexProperty < property.length()) {
            char lastChar = property.charAt(indexProperty);
            if (this.areEqualsCI(lastChar, 's') && this.isEndOfWord(property, indexProperty + 1)) {
                return indexColumn;
            }
            if (indexProperty + 1 < property.length()) {
                if (this.areEqualsCI(lastChar, 'e') && this.areEqualsCI(property.charAt(indexProperty + 1), 's') && this.isEndOfWord(property, indexProperty + 2)) {
                    if (indexColumn + 2 < column.length() && this.areEqualsCI(column.charAt(indexColumn + 1), 'i') && this.areEqualsCI(column.charAt(indexColumn + 2), 's')) {
                        return indexColumn + 3;
                    }
                    if (this.endWiths(column, this.from, indexColumn, {'s'}, {'s', 's'}, {'s', 'h'}, {'c', 'h'}, {'x'}, {'z'}, {'o'})) {
                        return indexColumn;
                    }
                }
                if (indexProperty + 2 < property.length()) {
                    if (this.areEqualsCI(lastChar, 'i') && this.areEqualsCI(property.charAt(indexProperty + 1), 'e') && this.areEqualsCI(property.charAt(indexProperty + 2), 's') && this.isEndOfWord(property, indexProperty + 3) && indexColumn + 1 < column.length() && this.areEqualsCI(column.charAt(indexColumn + 1), 'y')) {
                        return indexColumn + 2;
                    }
                    if (this.areEqualsCI(lastChar, 'z') && this.areEqualsCI(property.charAt(indexProperty + 1), 'e') && this.areEqualsCI(property.charAt(indexProperty + 2), 's') && this.isEndOfWord(property, indexProperty + 3) && indexColumn - 1 < column.length() && this.areEqualsCI(column.charAt(indexColumn - 1), 'z')) {
                        return indexColumn;
                    }
                    if (this.areEqualsCI(lastChar, 's') && this.areEqualsCI(property.charAt(indexProperty + 1), 'e') && this.areEqualsCI(property.charAt(indexProperty + 2), 's') && this.isEndOfWord(property, indexProperty + 3) && indexColumn - 1 < column.length() && this.areEqualsCI(column.charAt(indexColumn - 1), 's')) {
                        return indexColumn;
                    }
                    if (this.areEqualsCI(lastChar, 'v') && this.areEqualsCI(property.charAt(indexProperty + 1), 'e') && this.areEqualsCI(property.charAt(indexProperty + 2), 's') && this.isEndOfWord(property, indexProperty + 3) && indexColumn + 1 < column.length() && this.areEqualsCI(column.charAt(indexColumn + 1), 'f')) {
                        return indexColumn + 2;
                    }
                }
            }
        }
        return -1;
    }

    private boolean areEqualsCI(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private boolean endWiths(CharSequence column, int from, int indexColumn, char[] ... chars) {
        block0: for (int i = 0; i < chars.length; ++i) {
            char[] cs = chars[i];
            int offset = indexColumn - cs.length;
            if (offset <= from) continue;
            for (int j = 0; j < cs.length; ++j) {
                if (!this.areEqualsCI(cs[j], column.charAt(offset + j))) continue block0;
            }
            return true;
        }
        return false;
    }

    private boolean isEndOfWord(CharSequence property, int nextIndexProperty) {
        return nextIndexProperty >= property.length() || Character.isUpperCase(property.charAt(nextIndexProperty)) || DefaultPropertyNameMatcher.isSeparatorChar(property.charAt(nextIndexProperty));
    }

    private boolean areDifferentCharacters(char c1, char c2) {
        if (this.caseSensitive) {
            return c1 != c2;
        }
        return Character.toLowerCase(c1) != Character.toLowerCase(c2);
    }

    private boolean ignoreCharacter(char charColumn) {
        return !this.exactMatch && DefaultPropertyNameMatcher.isSeparatorChar(charColumn);
    }

    public static boolean isSeparatorChar(char charColumn) {
        return charColumn == '_' || charColumn == ' ' || charColumn == '.' || charColumn == '-';
    }

    private int meaningfulChar(CharSequence cs, int from, int to) {
        int s = 0;
        for (int i = from; i < to; ++i) {
            if (this.ignoreCharacter(cs.charAt(i))) continue;
            ++s;
        }
        return s;
    }

    @Override
    public PropertyNameMatch speculativeMatch() {
        int index = this._speculativeMatch();
        if (index != -1) {
            int score = this.meaningfulChar(this.column, this.from, index);
            return new PropertyNameMatch(this.column.substring(this.from, index), this.column, new DefaultPropertyNameMatcher(this.column, index, this.exactMatch, this.caseSensitive), score, 0);
        }
        return null;
    }

    @Override
    public List<PropertyNameMatcherKeyValuePair> keyValuePairs() {
        int f;
        ArrayList<PropertyNameMatcherKeyValuePair> keyValuePairs = new ArrayList<PropertyNameMatcherKeyValuePair>();
        for (f = this.from; f < this.column.length() && DefaultPropertyNameMatcher.isSeparatorChar(this.column.charAt(f)); ++f) {
        }
        keyValuePairs.add(new PropertyNameMatcherKeyValuePair(new DefaultPropertyNameMatcher(this.column, f, this.exactMatch, this.caseSensitive), new DefaultPropertyNameMatcher("", 0, this.exactMatch, this.caseSensitive)));
        for (int i = this.column.length() - 1; i >= f; --i) {
            char c = this.column.charAt(i);
            if (!DefaultPropertyNameMatcher.isSeparatorChar(c)) continue;
            DefaultPropertyNameMatcher key = new DefaultPropertyNameMatcher(this.column.substring(f, i), 0, this.exactMatch, this.caseSensitive);
            DefaultPropertyNameMatcher value = new DefaultPropertyNameMatcher(this.column, i + 1, this.exactMatch, this.caseSensitive);
            keyValuePairs.add(new PropertyNameMatcherKeyValuePair(key, value));
        }
        return keyValuePairs;
    }

    @Override
    public int asScore() {
        return DefaultPropertyNameMatcher.toScore(this.column, this.from);
    }

    private int _speculativeMatch() {
        for (int i = this.from; i < this.column.length(); ++i) {
            char c = this.column.charAt(i);
            if (c != '_' && c != '.' && c != ' ' && c != '-') continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.column.substring(this.from, this.column.length());
    }

    public static int toScore(String property) {
        return DefaultPropertyNameMatcher.toScore(property, 0);
    }

    public static int toScore(String property, int from) {
        int s = 0;
        for (int i = from; i < property.length(); ++i) {
            if (DefaultPropertyNameMatcher.isSeparatorChar(property.charAt(i))) continue;
            ++s;
        }
        return s;
    }

    public static PropertyNameMatcher of(String value) {
        return new DefaultPropertyNameMatcher(value, 0, false, false);
    }

    public static PropertyNameMatcher exact(String value) {
        return new DefaultPropertyNameMatcher(value, 0, true, true);
    }
}

