/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.api.auth.AuthAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.auth.Project;
import org.apache.hugegraph.structure.constant.HugeType;

public class ProjectAPI
extends AuthAPI {
    private static final String ACTION_ADD_GRAPH = "add_graph";
    private static final String ACTION_REMOVE_GRAPH = "remove_graph";

    public ProjectAPI(RestClient client, String graphSpace) {
        super(client, graphSpace);
    }

    @Override
    protected String type() {
        return HugeType.PROJECT.string();
    }

    public Project create(Project project) {
        RestResult result = this.client.post(this.path(), project);
        return (Project)result.readObject(Project.class);
    }

    public Project get(Object id) {
        RestResult result = this.client.get(this.path(), ProjectAPI.formatEntityId(id));
        return (Project)result.readObject(Project.class);
    }

    public List<Project> list(long limit) {
        ProjectAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map<String, Object>)params);
        return result.readList(this.type(), Project.class);
    }

    public Project update(Project project) {
        String id = ProjectAPI.formatEntityId(project.id());
        RestResult result = this.client.put(this.path(), id, project);
        return (Project)result.readObject(Project.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), ProjectAPI.formatEntityId(id));
    }

    public Project addGraphs(Object projectId, Set<String> graphs) {
        Project project = new Project();
        project.graphs(graphs);
        RestResult result = this.client.put(this.path(), ProjectAPI.formatEntityId(projectId), (Object)project, (Map<String, Object>)ImmutableMap.of((Object)"action", (Object)ACTION_ADD_GRAPH));
        return (Project)result.readObject(Project.class);
    }

    public Project removeGraphs(Object projectId, Set<String> graphs) {
        Project project = new Project();
        project.graphs(graphs);
        RestResult result = this.client.put(this.path(), ProjectAPI.formatEntityId(projectId), (Object)project, (Map<String, Object>)ImmutableMap.of((Object)"action", (Object)ACTION_REMOVE_GRAPH));
        return (Project)result.readObject(Project.class);
    }
}

