/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graphs;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.InvalidResponseException;
import org.apache.hugegraph.rest.RestHeaders;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.GraphMode;
import org.apache.hugegraph.structure.constant.GraphReadMode;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public class GraphsAPI
extends API {
    private static final String DELIMITER = "/";
    private static final String MODE = "mode";
    private static final String GRAPH_READ_MODE = "graph_read_mode";
    private static final String CLEAR = "clear";
    private static final String CONFIRM_MESSAGE = "confirm_message";
    private static final String CLEARED = "cleared";
    private static final String RELOADED = "reloaded";
    private static final String UPDATED = "updated";
    private static final String GRAPHS = "graphs";
    private static final String MANAGE = "manage";
    private static final String PATH = "graphspaces/%s/graphs";

    public GraphsAPI(RestClient client, String graphSpace) {
        super(client);
        this.path(String.format(PATH, graphSpace));
    }

    private static String joinPath(String path, String graph) {
        return String.join((CharSequence)DELIMITER, path, graph);
    }

    private static String joinPath(String path, String graph, String action) {
        return String.join((CharSequence)DELIMITER, path, graph, action);
    }

    @Override
    protected String type() {
        return HugeType.GRAPHS.string();
    }

    public Map<String, String> create(String name, String cloneGraphName, String configText) {
        this.client.checkApiVersion("0.67", "dynamic graph add");
        RestHeaders headers = new RestHeaders().add("Content-Type", "text/plain");
        ImmutableMap params = null;
        if (StringUtils.isNotEmpty((CharSequence)cloneGraphName)) {
            params = ImmutableMap.of((Object)"clone_graph_name", (Object)cloneGraphName);
        }
        RestResult result = this.client.post(GraphsAPI.joinPath(this.path(), name), configText, headers, (Map<String, Object>)params);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, String> get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (Map)result.readObject(Map.class);
    }

    public List<String> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), String.class);
    }

    public List<Map<String, Object>> listProfile(String prefix) {
        String profilePath = GraphsAPI.joinPath(this.path(), "profile");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("prefix", prefix);
        RestResult result = this.client.get(profilePath, params);
        List results = result.readList(Map.class);
        ArrayList<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
        for (Object entry : results) {
            profiles.add(JsonUtil.fromJson(JsonUtil.toJson(entry), Map.class));
        }
        return profiles;
    }

    public Map<String, String> setDefault(String name) {
        String defaultPath = GraphsAPI.joinPath(this.path(), name, "default");
        RestResult result = this.client.get(defaultPath);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, String> unSetDefault(String name) {
        String unDefaultPath = GraphsAPI.joinPath(this.path(), name, "undefault");
        RestResult result = this.client.get(unDefaultPath);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, String> getDefault() {
        String defaultPath = GraphsAPI.joinPath(this.path(), "default");
        RestResult result = this.client.get(defaultPath);
        return (Map)result.readObject(Map.class);
    }

    public void clear(String graph) {
        this.clear(graph, "I'm sure to delete all data");
    }

    public void clear(String graph, boolean clearSchema) {
        this.clear(graph, "I'm sure to delete all data");
    }

    public void clear(String graph, String message) {
        this.client.delete(GraphsAPI.joinPath(this.path(), graph, CLEAR), (Map<String, Object>)ImmutableMap.of((Object)CONFIRM_MESSAGE, (Object)message));
    }

    public Map<String, String> update(String name, String nickname) {
        HashMap<String, String> actionMap = new HashMap<String, String>();
        actionMap.put("name", name);
        actionMap.put("nickname", nickname);
        RestResult result = this.client.put(this.path(), name, ImmutableMap.of((Object)"action", (Object)"update", (Object)"update", actionMap));
        Map response = (Map)result.readObject(Map.class);
        E.checkState((response.size() == 1 && response.containsKey(name) ? 1 : 0) != 0, (String)"Response must be formatted to {\"%s\" : status}, but got %s", (Object[])new Object[]{name, response});
        String status = (String)response.get(name);
        E.checkState((boolean)UPDATED.equals(status), (String)"Server status must be '%s', but got '%s'", (Object[])new Object[]{UPDATED, status});
        return response;
    }

    public void delete(String graph) {
        this.drop(graph, "I'm sure to drop the graph");
    }

    public void drop(String graph, String message) {
        this.client.checkApiVersion("0.67", "dynamic graph delete");
        this.client.delete(GraphsAPI.joinPath(this.path(), graph), (Map<String, Object>)ImmutableMap.of((Object)CONFIRM_MESSAGE, (Object)message));
    }

    public Map<String, String> reload(String name) {
        RestResult result = this.client.put(this.path(), name, ImmutableMap.of((Object)"action", (Object)"reload"));
        Map response = (Map)result.readObject(Map.class);
        E.checkState((response.size() == 1 && response.containsKey(name) ? 1 : 0) != 0, (String)"Response must be formatted to {\"%s\" : status}, but got %s", (Object[])new Object[]{name, response});
        String status = (String)response.get(name);
        E.checkState((boolean)RELOADED.equals(status), (String)"Graph %s status must be %s, but got '%s'", (Object[])new Object[]{name, RELOADED, status});
        return response;
    }

    public Map<String, String> reload() {
        RestResult result = this.client.put(this.path(), MANAGE, ImmutableMap.of((Object)"action", (Object)"reload"));
        Map response = (Map)result.readObject(Map.class);
        E.checkState((response.size() == 1 && response.containsKey(GRAPHS) ? 1 : 0) != 0, (String)"Response must be formatted to {\"%s\" : status}, but got %s", (Object[])new Object[]{GRAPHS, response});
        String status = (String)response.get(GRAPHS);
        E.checkState((boolean)RELOADED.equals(status), (String)"Server status must be '%s', but got '%s'", (Object[])new Object[]{RELOADED, status});
        return response;
    }

    public void mode(String graph, GraphMode mode) {
        this.client.put(GraphsAPI.joinPath(this.path(), graph, MODE), null, (Object)mode);
    }

    public GraphMode mode(String graph) {
        RestResult result = this.client.get(GraphsAPI.joinPath(this.path(), graph), MODE);
        Map mode = (Map)result.readObject(Map.class);
        String value = (String)mode.get(MODE);
        if (value == null) {
            throw new InvalidResponseException("Invalid response, expect 'mode' in response", new Object[0]);
        }
        try {
            return GraphMode.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidResponseException("Invalid GraphMode value '%s'", value);
        }
    }

    public void readMode(String graph, GraphReadMode readMode) {
        this.client.checkApiVersion("0.59", "graph read mode");
        this.client.put(GraphsAPI.joinPath(this.path(), graph, GRAPH_READ_MODE), null, (Object)readMode);
    }

    public GraphReadMode readMode(String graph) {
        this.client.checkApiVersion("0.59", "graph read mode");
        RestResult result = this.client.get(GraphsAPI.joinPath(this.path(), graph), GRAPH_READ_MODE);
        Map readMode = (Map)result.readObject(Map.class);
        String value = (String)readMode.get(GRAPH_READ_MODE);
        if (value == null) {
            throw new InvalidResponseException("Invalid response, expect 'graph_read_mode' in response", new Object[0]);
        }
        try {
            return GraphReadMode.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidResponseException("Invalid GraphReadMode value '%s'", value);
        }
    }

    public String clone(String graph, Map<String, Object> body) {
        RestResult result = this.client.post(GraphsAPI.joinPath(this.path(), graph, "clone"), body);
        Map resultMap = (Map)result.readObject(Map.class);
        String taskId = (String)resultMap.get("task_id");
        return taskId;
    }
}

