/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.filter.ElementLimitFilter;
import org.apache.hugegraph.loader.filter.ElementParser;
import org.apache.hugegraph.loader.filter.ShortIdParser;
import org.apache.hugegraph.structure.GraphElement;

public class ElementParseGroup {
    List<ElementParser> parser = new ArrayList<ElementParser>();

    private ElementParseGroup() {
    }

    public static ElementParseGroup create(LoadOptions options) {
        ElementParseGroup group = new ElementParseGroup();
        if (options.vertexEdgeLimit != -1L) {
            group.addFilter(new ElementLimitFilter(options.vertexEdgeLimit));
        }
        if (!options.shorterIDConfigs.isEmpty()) {
            group.addFilter(new ShortIdParser(options));
        }
        return group;
    }

    void addFilter(ElementParser filter) {
        this.parser.add(filter);
    }

    void removeFilter(ElementParser filter) {
        this.parser.remove(filter);
    }

    public boolean filter(GraphElement element) {
        for (ElementParser parser : this.parser) {
            boolean r = parser.parse(element);
            if (r) continue;
            return false;
        }
        return true;
    }
}

