/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.LoadMapping;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.struct.EdgeStructV1;
import org.apache.hugegraph.loader.struct.ElementStructV1;
import org.apache.hugegraph.loader.struct.GraphStructV1;
import org.apache.hugegraph.loader.struct.VertexStructV1;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public final class MappingUtil {
    private static final Set<String> ACCEPTABLE_VERSIONS = ImmutableSet.of((Object)"1.0", (Object)"2.0");

    public static void write(LoadMapping mapping, String path) {
        File file = FileUtils.getFile((String[])new String[]{path});
        String json = JsonUtil.toJson(mapping);
        try {
            FileUtils.write((File)file, (CharSequence)json, (Charset)Constants.CHARSET);
        }
        catch (IOException e) {
            throw new LoadException("Failed to write mapping %s to file '%s'", (Throwable)e, mapping, file);
        }
    }

    public static LoadMapping parse(String json) {
        Map<String, Object> map = JsonUtil.convertMap(json, String.class, Object.class);
        Object value = map.get("version");
        if (value == null) {
            value = "1.0";
        } else {
            E.checkArgument((boolean)(value instanceof String), (String)"The version value must be String class, but got '%s(%s)'", (Object[])new Object[]{value, value.getClass()});
        }
        String version = (String)value;
        E.checkArgument((boolean)ACCEPTABLE_VERSIONS.contains(version), (String)"Invalid version '%s', the acceptable versions are %s", (Object[])new Object[]{version, ACCEPTABLE_VERSIONS});
        if (version.equals("2.0")) {
            return JsonUtil.fromJson(json, LoadMapping.class);
        }
        assert (version.equals("1.0"));
        return MappingUtil.parseV1(json);
    }

    private static LoadMapping parseV1(String json) {
        GraphStructV1 graphStruct = JsonUtil.fromJson(json, GraphStructV1.class);
        Map fileSourceInputStructs = InsertionOrderUtil.newMap();
        ArrayList<InputStruct> jdbcSourceInputStructs = new ArrayList<InputStruct>();
        for (ElementStructV1 originStruct : graphStruct.structs()) {
            InputSource inputSource = originStruct.input();
            ElementMapping targetStruct = MappingUtil.convertV1ToV2(originStruct);
            SourceType type = inputSource.type();
            if (type == SourceType.FILE || type == SourceType.HDFS) {
                FileSource source = (FileSource)inputSource;
                FileSourceKey key = new FileSourceKey(type, source.path());
                fileSourceInputStructs.compute(key, (k, inputStruct) -> {
                    if (inputStruct == null) {
                        inputStruct = new InputStruct(null, null);
                        inputStruct.input(source);
                    }
                    inputStruct.add(targetStruct);
                    return inputStruct;
                });
                continue;
            }
            assert (type == SourceType.JDBC);
            InputStruct inputStruct2 = new InputStruct(null, null);
            inputStruct2.input(inputSource);
            inputStruct2.add(targetStruct);
            jdbcSourceInputStructs.add(inputStruct2);
        }
        ArrayList<InputStruct> inputStructs = new ArrayList<InputStruct>();
        int id = 0;
        for (InputStruct inputStruct3 : fileSourceInputStructs.values()) {
            inputStruct3.id(String.valueOf(++id));
            inputStructs.add(inputStruct3);
        }
        for (InputStruct inputStruct3 : jdbcSourceInputStructs) {
            inputStruct3.id(String.valueOf(++id));
            inputStructs.add(inputStruct3);
        }
        return new LoadMapping(inputStructs);
    }

    private static ElementMapping convertV1ToV2(ElementStructV1 origin) {
        ElementMapping target;
        if (origin.type().isVertex()) {
            VertexStructV1 originVertex = (VertexStructV1)origin;
            target = new VertexMapping(originVertex.idField(), originVertex.unfold());
        } else {
            EdgeStructV1 originEdge = (EdgeStructV1)origin;
            target = new EdgeMapping(originEdge.sourceFields(), originEdge.unfoldSource(), originEdge.targetFields(), originEdge.unfoldTarget());
        }
        MappingUtil.fill(origin, target);
        return target;
    }

    private static void fill(ElementStructV1 originStruct, ElementMapping targetStruct) {
        targetStruct.label(originStruct.label());
        targetStruct.skip(originStruct.skip());
        targetStruct.mappingFields(originStruct.mappingFields());
        targetStruct.mappingValues(originStruct.mappingValues());
        targetStruct.selectedFields(originStruct.selectedFields());
        targetStruct.ignoredFields(originStruct.ignoredFields());
        targetStruct.nullValues(originStruct.nullValues());
        targetStruct.updateStrategies(originStruct.updateStrategies());
    }

    private static class FileSourceKey {
        private final SourceType type;
        private final String path;

        public FileSourceKey(SourceType type, String path) {
            this.type = type;
            this.path = path;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FileSourceKey)) {
                return false;
            }
            FileSourceKey other = (FileSourceKey)object;
            return this.type == other.type && this.path.equals(other.path);
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.path.hashCode();
        }
    }
}

