/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

public class UrlParseUtil {
    public static Host parseHost(String url) {
        Host host = new Host();
        String text = url;
        String scheme = null;
        int schemeIdx = url.indexOf("://");
        if (schemeIdx > 0) {
            scheme = url.substring(0, schemeIdx);
            text = url.substring(schemeIdx + 3);
        }
        int port = -1;
        int portIdx = text.lastIndexOf(":");
        if (portIdx > 0) {
            String portStr = null;
            int pathIdx = text.indexOf("/");
            portStr = pathIdx > 0 ? text.substring(portIdx + 1, pathIdx) : text.substring(portIdx + 1);
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid HTTP host: " + text, e);
            }
            text = text.substring(0, portIdx);
            host.setScheme(scheme);
            host.setHost(text);
            host.setPort(port);
        }
        return host;
    }

    public static class Host {
        protected String host;
        protected int port;
        protected String scheme;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Host)) {
                return false;
            }
            Host other = (Host)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$scheme = this.getScheme();
            String other$scheme = other.getScheme();
            return !(this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Host;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            result = result * 59 + this.getPort();
            String $scheme = this.getScheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            return result;
        }

        public String toString() {
            return "UrlParseUtil.Host(host=" + this.getHost() + ", port=" + this.getPort() + ", scheme=" + this.getScheme() + ")";
        }

        public Host() {
        }

        public Host(String host, int port, String scheme) {
            this.host = host;
            this.port = port;
            this.scheme = scheme;
        }
    }
}

