/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.beust.jcommander.JCommander;
import java.util.Map;
import java.util.Scanner;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.exception.ExitException;

public final class ToolUtil {
    public static void printOrThrow(Throwable e, boolean throwMode) {
        Printer.print("Failed to execute %s", e.getMessage());
        if (throwMode) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        ToolUtil.printExceptionStackIfNeeded(e);
    }

    public static void printExceptionStackIfNeeded(Throwable e) {
        System.out.println("Type y(yes) to print exception stack[default n]?");
        Scanner scan = new Scanner(System.in);
        String inputInfomation = scan.nextLine();
        if (inputInfomation.equalsIgnoreCase("yes") || inputInfomation.equalsIgnoreCase("y")) {
            e.printStackTrace();
        }
    }

    public static void exitOrThrow(ExitException e, boolean throwMode) {
        if (throwMode) {
            throw e;
        }
        if (e.exitCode() != 0) {
            Printer.print(e.getMessage());
        }
        Printer.print(e.details());
    }

    public static String commandsCategory(JCommander jCommander) {
        StringBuilder sb = new StringBuilder();
        sb.append("================================================");
        sb.append("\n");
        sb.append("Warning : must provide one sub-command");
        sb.append("\n");
        sb.append("================================================");
        sb.append("\n");
        sb.append("Here are some sub-command :");
        sb.append("\n");
        Map subCommandes = jCommander.getCommands();
        for (String subCommand : subCommandes.keySet()) {
            sb.append("|");
            sb.append(subCommand);
            sb.append("\n");
        }
        sb.append("================================================");
        sb.append("\n");
        sb.append("Please use 'hugegraph help' to get detail help info of all sub-commands or 'hugegraph help {sub-command}' to get detail help info of one sub-command");
        sb.append("\n");
        sb.append("================================================");
        return sb.toString();
    }

    public static String commandUsage(JCommander jCommander) {
        StringBuilder sb = new StringBuilder();
        jCommander.usage(sb);
        return sb.toString();
    }
}

