/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class GraphFetcher
implements Iterator<GraphElement> {
    public static final Logger LOG = Log.logger(GraphFetcher.class);
    private final HugeClient client;
    private final String label;
    private final Map<String, Object> queryProperties;
    private final int batchSize;
    private final boolean isVertex;
    private final List<String> ignoredProperties;
    private int offset = 0;
    private boolean done = false;
    private Iterator<GraphElement> batchIter;

    public GraphFetcher(HugeClient client, String label, Map<String, Object> queryProperties, int batchSize, boolean isVertex, List<String> ignoredProperties) {
        this.client = client;
        this.label = label;
        this.queryProperties = queryProperties;
        this.batchSize = batchSize;
        this.isVertex = isVertex;
        this.ignoredProperties = ignoredProperties;
        this.offset = 0;
        this.done = false;
    }

    private List<GraphElement> queryBatch() {
        ArrayList<GraphElement> elements = new ArrayList<GraphElement>();
        if (this.done) {
            return elements;
        }
        if (this.isVertex) {
            elements.addAll(this.client.graph().listVertices(this.label, this.queryProperties, true, this.offset, this.batchSize));
        } else {
            elements.addAll(this.client.graph().getEdges(null, null, this.label, this.queryProperties, true, this.offset, this.batchSize));
        }
        elements.stream().forEach(e -> this.ignoreProperties((GraphElement)e));
        if (elements.size() < this.batchSize) {
            this.done = true;
        }
        this.offset += elements.size();
        return elements;
    }

    private void queryIfNecessary() {
        if (this.batchIter == null || !this.batchIter.hasNext()) {
            this.batchIter = this.queryBatch().iterator();
        }
    }

    @Override
    public boolean hasNext() {
        this.queryIfNecessary();
        return this.batchIter.hasNext();
    }

    @Override
    public GraphElement next() {
        this.queryIfNecessary();
        return this.batchIter.next();
    }

    private void ignoreProperties(GraphElement element) {
        if (element != null && !CollectionUtils.isEmpty(this.ignoredProperties)) {
            for (String property : this.ignoredProperties) {
                element.properties().remove(property);
            }
        }
    }
}

