/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DirFilter {
    private static final String DEFAULT_INCLUDE = "";
    private static final String DEFAULT_EXCLUDE = "";
    @JsonProperty(value="include_regex")
    String includeRegex = DEFAULT_INCLUDE;
    @JsonProperty(value="exclude_regex")
    String excludeRegex = DEFAULT_EXCLUDE;
    private transient Matcher includeMatcher = null;
    private transient Matcher excludeMatcher = null;

    private Matcher includeMatcher() {
        if (this.includeMatcher == null && !StringUtils.isEmpty((CharSequence)this.includeRegex)) {
            this.includeMatcher = Pattern.compile(this.includeRegex).matcher("");
        }
        return this.includeMatcher;
    }

    private Matcher excludeMatcher() {
        if (this.excludeMatcher == null && !StringUtils.isEmpty((CharSequence)this.excludeRegex)) {
            this.excludeMatcher = Pattern.compile(this.excludeRegex).matcher("");
        }
        return this.excludeMatcher;
    }

    private boolean includeMatch(String dirName) {
        if (!StringUtils.isEmpty((CharSequence)this.includeRegex)) {
            return this.includeMatcher().reset(dirName).matches();
        }
        return true;
    }

    private boolean excludeMatch(String dirName) {
        if (!StringUtils.isEmpty((CharSequence)this.excludeRegex)) {
            return this.excludeMatcher().reset(dirName).matches();
        }
        return false;
    }

    public boolean reserved(String dirName) {
        return this.includeMatch(dirName) && !this.excludeMatch(dirName);
    }
}

