/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.task;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.Log;
import org.parboiled.common.Preconditions;
import org.slf4j.Logger;

public class GlobalExecutorManager {
    private static final Logger LOG = Log.logger(GlobalExecutorManager.class);
    private static final int CPUS;
    private static int batchThreadCount;
    private static int singleThreadCount;
    private static final Map<String, ExecutorService> EXECUTORS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getExecutor(int parallel, String name) {
        Preconditions.checkArgNotNull((Object)name, (String)"executor name");
        Preconditions.checkArgument((parallel > 0 ? 1 : 0) != 0, (Object)"executor pool size must > 0");
        Map<String, ExecutorService> map = EXECUTORS;
        synchronized (map) {
            if (!EXECUTORS.containsKey(name)) {
                String patternName = name + "-%d";
                ExecutorService executor = ExecutorUtil.newFixedThreadPool((int)parallel, (String)patternName);
                EXECUTORS.put(name, executor);
            }
            return EXECUTORS.get(name);
        }
    }

    public static void shutdown(int timeout) {
        EXECUTORS.forEach((name, executor) -> {
            block6: {
                if (executor.isShutdown()) {
                    return;
                }
                try {
                    executor.shutdown();
                    executor.awaitTermination(timeout, TimeUnit.SECONDS);
                    LOG.info(String.format("The %s executor shutdown", name));
                    if (executor.isTerminated()) break block6;
                }
                catch (InterruptedException e) {
                    block7: {
                        try {
                            LOG.error("The batch-mode tasks are interrupted", (Throwable)e);
                            if (executor.isTerminated()) break block7;
                        }
                        catch (Throwable throwable) {
                            if (!executor.isTerminated()) {
                                LOG.error(String.format("The unfinished tasks will be cancelled in executor (%s)", name));
                            }
                            executor.shutdownNow();
                            throw throwable;
                        }
                        LOG.error(String.format("The unfinished tasks will be cancelled in executor (%s)", name));
                    }
                    executor.shutdownNow();
                }
                LOG.error(String.format("The unfinished tasks will be cancelled in executor (%s)", name));
            }
            executor.shutdownNow();
        });
    }

    public static void setBatchThreadCount(int count) {
        batchThreadCount = count;
    }

    public static void setSingleThreadCount(int count) {
        singleThreadCount = count;
    }

    public static synchronized ExecutorService getBatchInsertExecutor() {
        return GlobalExecutorManager.getExecutor(batchThreadCount, "batch-worker");
    }

    public static synchronized ExecutorService getSingleInsertExecutor() {
        return GlobalExecutorManager.getExecutor(singleThreadCount, "single-worker");
    }

    static {
        batchThreadCount = CPUS = Runtime.getRuntime().availableProcessors();
        singleThreadCount = CPUS;
        EXECUTORS = new HashMap<String, ExecutorService>();
    }
}

