/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.task;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hugegraph.loader.builder.Record;
import org.apache.hugegraph.loader.exception.InsertException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.task.InsertTask;
import org.apache.hugegraph.loader.task.TaskManager;
import org.apache.hugegraph.loader.util.Printer;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class SingleInsertTask
extends InsertTask {
    private static final Logger LOG = Log.logger(TaskManager.class);

    public SingleInsertTask(LoadContext context, InputStruct struct, ElementMapping mapping, List<Record> batch) {
        super(context, struct, mapping, batch);
    }

    @Override
    public void execute() {
        for (Record record : this.batch) {
            try {
                if (this.mapping.updateStrategies().isEmpty()) {
                    this.insertSingle(this.options(), record);
                } else {
                    this.updateSingle(this.options(), record);
                }
                this.increaseLoadSuccess();
            }
            catch (Exception e) {
                this.metrics().increaseInsertFailure(this.mapping);
                InsertException ie = new InsertException(record.rawLine(), e);
                this.handleInsertFailure(ie);
            }
        }
        Printer.printProgress(this.context, this.type(), 10000L, this.batch.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInsertFailure(InsertException e) {
        LOG.error("Single insert {} error", (Object)this.type(), (Object)e);
        this.context.occurredError();
        if (this.options().testMode) {
            throw e;
        }
        this.context.failureLogger(this.struct).write(e);
        long failures = this.context.summary().totalInsertFailures();
        if (this.options().maxInsertErrors != -1 && failures >= (long)this.options().maxInsertErrors) {
            if (this.context.stopped()) {
                return;
            }
            LoadContext loadContext = this.context;
            synchronized (loadContext) {
                if (!this.context.stopped()) {
                    Printer.printError("More than %s %s insert error, stop parsing and waiting other insert tasks stopped", this.options().maxInsertErrors, this.type().string());
                    this.context.stopLoading();
                }
            }
        }
    }

    private void insertSingle(LoadOptions options, Record record) {
        this.insertBatch((List<Record>)ImmutableList.of((Object)record), options.checkVertex);
    }

    private void updateSingle(LoadOptions options, Record record) {
        this.updateBatch((List<Record>)ImmutableList.of((Object)record), options.checkVertex);
    }
}

