/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.space;

import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.space.HStoreNodeInfo;

public class HStoreAPI
extends API {
    private static final String PATH = "hstore";

    public HStoreAPI(RestClient client) {
        super(client);
        this.path(this.type());
    }

    @Override
    protected String type() {
        return HugeType.HSTORE.string();
    }

    public List<String> list() {
        RestResult result = this.client.get(this.path());
        return result.readList("nodes", String.class);
    }

    public HStoreNodeInfo get(String id) {
        RestResult result = this.client.get(this.path(), id);
        return (HStoreNodeInfo)result.readObject(HStoreNodeInfo.class);
    }

    public String status() {
        RestResult result = this.client.get(this.path(), "status");
        return (String)((Map)result.readObject(Map.class)).get("status");
    }

    public void startSplit() {
        this.client.get(this.path(), "split");
    }

    public void nodeStartup(String id) {
        String startupPath = HStoreAPI.joinPath(this.path(), id, "startup");
        this.client.get(startupPath);
    }

    public void nodeShutdown(String id) {
        String startupPath = HStoreAPI.joinPath(this.path(), id, "shutdown");
        this.client.get(startupPath);
    }
}

