/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.auth;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.structure.auth.AuthElement;
import org.apache.hugegraph.structure.auth.HugeResource;
import org.apache.hugegraph.structure.constant.HugeType;

public class Target
extends AuthElement {
    @JsonProperty(value="target_name")
    protected String name;
    @JsonProperty(value="graphspace")
    protected String graphSpace;
    @JsonProperty(value="target_graph")
    protected String graph;
    @JsonProperty(value="target_url")
    protected String url;
    @JsonProperty(value="target_description")
    protected String description;
    @JsonProperty(value="target_resources")
    protected Object resources;
    @JsonProperty(value="target_create")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date create;
    @JsonProperty(value="target_update")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date update;
    @JsonProperty(value="target_creator")
    protected String creator;

    @Override
    public String type() {
        return HugeType.TARGET.string();
    }

    @Override
    public Date createTime() {
        return this.create;
    }

    @Override
    public Date updateTime() {
        return this.update;
    }

    @Override
    public String creator() {
        return this.creator;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String graphSpace() {
        return this.graphSpace;
    }

    public void graphSpace(String graphSpace) {
        this.graphSpace = graphSpace;
    }

    public String graph() {
        return this.graph;
    }

    public void graph(String graph) {
        this.graph = graph;
    }

    public String url() {
        return this.url;
    }

    public void url(String url) {
        this.url = url;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public List<Map<String, Object>> resourcesList() {
        if (this.resources == null) {
            return null;
        }
        if (this.resources instanceof List) {
            return (List)this.resources;
        }
        return null;
    }

    public Map<String, List<HugeResource>> resources() {
        if (this.resources == null) {
            return null;
        }
        if (this.resources instanceof Map) {
            return (Map)this.resources;
        }
        return null;
    }

    @JsonSetter(value="target_resources")
    protected void setResourcesFromJson(Object value) {
        if (value == null) {
            this.resources = null;
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList list = new ArrayList();
            for (List resList : map.values()) {
                list.addAll(resList);
            }
            this.resources = list;
        } else {
            this.resources = value;
        }
    }

    public void resources(List<Map<String, Object>> resources) {
        this.resources = resources;
    }

    public void resources(Map<String, List<HugeResource>> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        ArrayList list = new ArrayList();
        for (List<HugeResource> resList : resources.values()) {
            for (HugeResource res : resList) {
                HashMap<String, Object> resMap = new HashMap<String, Object>();
                resMap.put("type", res.resourceType().toString());
                resMap.put("label", res.label());
                resMap.put("properties", res.properties());
                list.add(resMap);
            }
        }
        this.resources = list;
    }
}

