/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class Graph {
    private static final Logger LOG = Log.logger(Graph.class);
    private Map<Object, HugeVertex> hugeVerticesMap;
    private List<HugeEdge> hugeEdges;

    public Graph(GraphManager graph) {
        LOG.debug("Loading Graph...");
        List<Vertex> vertices = graph.listVertices();
        LOG.debug("Loaded vertices: {}", (Object)vertices.size());
        List<Edge> edges = graph.listEdges();
        LOG.debug("Loaded edges: {}", (Object)edges.size());
        this.mergeEdges2Vertices(vertices, edges);
        LOG.debug("Loaded Graph");
    }

    public Graph(List<Vertex> vertices, List<Edge> edges) {
        this.mergeEdges2Vertices(vertices, edges);
    }

    public Iterator<HugeVertex> vertices() {
        return this.hugeVerticesMap.values().iterator();
    }

    public HugeVertex vertex(Object id) {
        return this.hugeVerticesMap.get(id);
    }

    public Iterator<HugeEdge> edges() {
        return this.hugeEdges.iterator();
    }

    private void mergeEdges2Vertices(List<Vertex> vertices, List<Edge> edges) {
        this.hugeVerticesMap = new HashMap<Object, HugeVertex>(vertices.size());
        for (Vertex v : vertices) {
            this.hugeVerticesMap.put(v.id(), new HugeVertex(v));
        }
        this.hugeEdges = new ArrayList<HugeEdge>(edges.size());
        for (Edge e : edges) {
            HugeVertex src = this.hugeVerticesMap.get(e.sourceId());
            HugeVertex tgt = this.hugeVerticesMap.get(e.targetId());
            HugeEdge edge = new HugeEdge(e);
            edge.source(src);
            edge.target(tgt);
            src.addEdge(edge);
            tgt.addEdge(edge);
            this.hugeEdges.add(edge);
        }
    }

    public static class HugeEdge {
        private final Edge edge;
        private HugeVertex source;
        private HugeVertex target;

        public HugeEdge(Edge e) {
            this.edge = e;
        }

        public Edge edge() {
            return this.edge;
        }

        public HugeVertex source() {
            return this.source;
        }

        public void source(HugeVertex source) {
            this.source = source;
        }

        public HugeVertex target() {
            return this.target;
        }

        public void target(HugeVertex target) {
            this.target = target;
        }

        public HugeVertex other(HugeVertex vertex) {
            return vertex == this.source ? this.target : this.source;
        }

        public String toString() {
            return String.format("HugeEdge{edge=%s, sourceId=%s, targetId=%s}", this.edge, this.source.vertex(), this.target.vertex());
        }
    }

    public static class HugeVertex {
        private Vertex vertex;
        private final List<HugeEdge> edges;

        public HugeVertex(Vertex v) {
            this.vertex = v;
            this.edges = new ArrayList<HugeEdge>();
        }

        public Vertex vertex() {
            return this.vertex;
        }

        public void vertex(Vertex vertex) {
            this.vertex = vertex;
        }

        public void addEdge(HugeEdge e) {
            this.edges.add(e);
        }

        public List<HugeEdge> getEdges() {
            return this.edges;
        }

        public String toString() {
            return String.format("HugeVertex{vertex=%s, edges=%s}", this.vertex, this.edges);
        }
    }
}

