/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.common;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.pd.grpc.Metapb;

public class PartitionCache {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, AtomicBoolean> locks = new HashMap<String, AtomicBoolean>();
    Lock writeLock = this.readWriteLock.writeLock();
    private volatile Map<String, RangeMap<Long, Integer>> keyToPartIdCache = new HashMap<String, RangeMap<Long, Integer>>();
    private volatile Map<String, Map<Integer, Metapb.Partition>> partitionCache = new HashMap<String, Map<Integer, Metapb.Partition>>();
    private volatile Map<Integer, Metapb.ShardGroup> shardGroupCache = new ConcurrentHashMap<Integer, Metapb.ShardGroup>();
    private volatile Map<Long, Metapb.Store> storeCache = new ConcurrentHashMap<Long, Metapb.Store>();
    private volatile Map<String, Metapb.Graph> graphCache = new ConcurrentHashMap<String, Metapb.Graph>();

    private AtomicBoolean getOrCreateGraphLock(String graphName) {
        AtomicBoolean lock = this.locks.get(graphName);
        if (lock == null) {
            try {
                this.writeLock.lock();
                lock = this.locks.get(graphName);
                if (lock == null) {
                    lock = new AtomicBoolean();
                    this.locks.put(graphName, lock);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return lock;
    }

    public void waitGraphLock(String graphName) {
        AtomicBoolean lock = this.getOrCreateGraphLock(graphName);
        while (lock.get()) {
            Thread.onSpinWait();
        }
    }

    public void lockGraph(String graphName) {
        AtomicBoolean lock = this.getOrCreateGraphLock(graphName);
        while (!lock.compareAndSet(false, true)) {
            Thread.onSpinWait();
        }
    }

    public void unlockGraph(String graphName) {
        AtomicBoolean lock = this.getOrCreateGraphLock(graphName);
        lock.set(false);
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionById(String graphName, int partId) {
        Metapb.Partition partition;
        this.waitGraphLock(graphName);
        Map<Integer, Metapb.Partition> graphs = this.partitionCache.get(graphName);
        if (graphs != null && (partition = graphs.get(partId)) != null) {
            return new KVPair<Metapb.Partition, Metapb.Shard>(partition, this.getLeaderShard(partId));
        }
        return null;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByKey(String graphName, byte[] key) {
        int code = PartitionUtils.calcHashcode(key);
        return this.getPartitionByCode(graphName, code);
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByCode(String graphName, long code) {
        Integer partId;
        this.waitGraphLock(graphName);
        RangeMap<Long, Integer> rangeMap = this.keyToPartIdCache.get(graphName);
        if (rangeMap != null && (partId = (Integer)rangeMap.get((Comparable)Long.valueOf(code))) != null) {
            return this.getPartitionById(graphName, partId);
        }
        return null;
    }

    public List<Metapb.Partition> getPartitions(String graphName) {
        this.waitGraphLock(graphName);
        ArrayList<Metapb.Partition> partitions = new ArrayList<Metapb.Partition>();
        if (!this.partitionCache.containsKey(graphName)) {
            return partitions;
        }
        this.partitionCache.get(graphName).forEach((k, v) -> partitions.add((Metapb.Partition)v));
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPartition(String graphName, int partId, Metapb.Partition partition) {
        this.waitGraphLock(graphName);
        Metapb.Partition old = null;
        if (this.partitionCache.containsKey(graphName)) {
            old = this.partitionCache.get(graphName).get(partId);
        }
        if (old != null && old.equals((Object)partition)) {
            return false;
        }
        try {
            this.lockGraph(graphName);
            this.partitionCache.computeIfAbsent(graphName, k -> new HashMap()).put(partId, partition);
            if (old != null) {
                RangeMap<Long, Integer> graphRange = this.keyToPartIdCache.get(graphName);
                if (Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getStartKey()))) && Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getEndKey() - 1L)))) {
                    graphRange.remove((Range)graphRange.getEntry((Comparable)Long.valueOf(partition.getStartKey())).getKey());
                }
            }
            this.keyToPartIdCache.computeIfAbsent(graphName, k -> TreeRangeMap.create()).put(Range.closedOpen((Comparable)Long.valueOf(partition.getStartKey()), (Comparable)Long.valueOf(partition.getEndKey())), (Object)partId);
        }
        finally {
            this.unlockGraph(graphName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartition(String graphName, int partId, Metapb.Partition partition) {
        try {
            this.lockGraph(graphName);
            Metapb.Partition old = null;
            Map<Integer, Metapb.Partition> graphs = this.partitionCache.get(graphName);
            if (graphs != null) {
                old = graphs.get(partId);
            }
            if (old != null) {
                RangeMap<Long, Integer> graphRange = this.keyToPartIdCache.get(graphName);
                if (Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getStartKey()))) && Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getEndKey() - 1L)))) {
                    graphRange.remove((Range)graphRange.getEntry((Comparable)Long.valueOf(partition.getStartKey())).getKey());
                }
            }
            this.partitionCache.computeIfAbsent(graphName, k -> new HashMap()).put(partId, partition);
            this.keyToPartIdCache.computeIfAbsent(graphName, k -> TreeRangeMap.create()).put(Range.closedOpen((Comparable)Long.valueOf(partition.getStartKey()), (Comparable)Long.valueOf(partition.getEndKey())), (Object)partId);
        }
        finally {
            this.unlockGraph(graphName);
        }
    }

    public boolean updatePartition(Metapb.Partition partition) {
        int partitionId;
        String graphName = partition.getGraphName();
        KVPair<Metapb.Partition, Metapb.Shard> old = this.getPartitionById(graphName, partitionId = partition.getId());
        if (old != null && Objects.equals(partition, old.getKey())) {
            return false;
        }
        this.updatePartition(graphName, partitionId, partition);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartition(String graphName, int partId) {
        try {
            this.lockGraph(graphName);
            Metapb.Partition partition = this.partitionCache.get(graphName).remove(partId);
            if (partition != null) {
                RangeMap<Long, Integer> graphRange = this.keyToPartIdCache.get(graphName);
                if (Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getStartKey()))) && Objects.equals(partition.getId(), graphRange.get((Comparable)Long.valueOf(partition.getEndKey() - 1L)))) {
                    graphRange.remove((Range)graphRange.getEntry((Comparable)Long.valueOf(partition.getStartKey())).getKey());
                }
            }
        }
        finally {
            this.unlockGraph(graphName);
        }
    }

    public void remove(String graphName, int id) {
        this.removePartition(graphName, id);
    }

    public void removePartitions() {
        this.writeLock.lock();
        try {
            this.partitionCache = new HashMap<String, Map<Integer, Metapb.Partition>>();
            this.keyToPartIdCache = new HashMap<String, RangeMap<Long, Integer>>();
            this.locks.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeAll(String graphName) {
        try {
            this.lockGraph(graphName);
            this.partitionCache.remove(graphName);
            this.keyToPartIdCache.remove(graphName);
            this.locks.remove(graphName);
        }
        finally {
            this.unlockGraph(graphName);
        }
    }

    private String makePartitionKey(String graphName, int partId) {
        return graphName + "/" + partId;
    }

    public boolean updateShardGroup(Metapb.ShardGroup shardGroup) {
        Metapb.ShardGroup oldShardGroup = this.shardGroupCache.get(shardGroup.getId());
        if (oldShardGroup != null && oldShardGroup.equals((Object)shardGroup)) {
            return false;
        }
        this.shardGroupCache.put(shardGroup.getId(), shardGroup);
        return true;
    }

    public void deleteShardGroup(int shardGroupId) {
        this.shardGroupCache.remove(shardGroupId);
    }

    public Metapb.ShardGroup getShardGroup(int groupId) {
        return this.shardGroupCache.get(groupId);
    }

    public boolean addStore(Long storeId, Metapb.Store store) {
        Metapb.Store oldStore = this.storeCache.get(storeId);
        if (oldStore != null && oldStore.equals((Object)store)) {
            return false;
        }
        this.storeCache.put(storeId, store);
        return true;
    }

    public Metapb.Store getStoreById(Long storeId) {
        return this.storeCache.get(storeId);
    }

    public void removeStore(Long storeId) {
        this.storeCache.remove(storeId);
    }

    public boolean hasGraph(String graphName) {
        return this.getPartitions(graphName).size() > 0;
    }

    public void updateGraph(Metapb.Graph graph) {
        if (Objects.equals(graph, this.getGraph(graph.getGraphName()))) {
            return;
        }
        this.graphCache.put(graph.getGraphName(), graph);
    }

    public Metapb.Graph getGraph(String graphName) {
        return this.graphCache.get(graphName);
    }

    public List<Metapb.Graph> getGraphs() {
        ArrayList<Metapb.Graph> graphs = new ArrayList<Metapb.Graph>();
        this.graphCache.forEach((k, v) -> graphs.add((Metapb.Graph)v));
        return graphs;
    }

    public void reset() {
        this.writeLock.lock();
        try {
            this.partitionCache = new HashMap<String, Map<Integer, Metapb.Partition>>();
            this.keyToPartIdCache = new HashMap<String, RangeMap<Long, Integer>>();
            this.shardGroupCache = new ConcurrentHashMap<Integer, Metapb.ShardGroup>();
            this.storeCache = new ConcurrentHashMap<Long, Metapb.Store>();
            this.graphCache = new ConcurrentHashMap<String, Metapb.Graph>();
            this.locks.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.reset();
    }

    public String debugCacheByGraphName(String graphName) {
        StringBuilder builder = new StringBuilder();
        builder.append("Graph:").append(graphName).append(", cache info: range info: {");
        RangeMap<Long, Integer> rangeMap = this.keyToPartIdCache.get(graphName);
        builder.append(rangeMap == null ? "" : rangeMap).append("}");
        if (rangeMap != null) {
            builder.append(", partition info : {");
            rangeMap.asMapOfRanges().forEach((k, v) -> {
                Metapb.Partition partition = this.partitionCache.get(graphName).get(v);
                builder.append("[part_id:").append(v);
                if (partition != null) {
                    builder.append(", start_key:").append(partition.getStartKey()).append(", end_key:").append(partition.getEndKey()).append(", state:").append(partition.getState().name());
                }
                builder.append("], ");
            });
            builder.append("}");
        }
        builder.append(", graph info:{");
        Metapb.Graph graph = this.graphCache.get(graphName);
        if (graph != null) {
            builder.append("partition_count:").append(graph.getPartitionCount()).append(", state:").append(graph.getState().name());
        }
        builder.append("}]");
        return builder.toString();
    }

    public Metapb.Shard getLeaderShard(int partitionId) {
        Metapb.ShardGroup shardGroup = this.shardGroupCache.get(partitionId);
        if (shardGroup != null) {
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                return shard;
            }
        }
        return null;
    }

    public void updateShardGroupLeader(int partitionId, Metapb.Shard leader) {
        if (this.shardGroupCache.containsKey(partitionId) && leader != null && !Objects.equals(this.getLeaderShard(partitionId), leader)) {
            Metapb.ShardGroup shardGroup = this.shardGroupCache.get(partitionId);
            Metapb.ShardGroup.Builder builder = Metapb.ShardGroup.newBuilder((Metapb.ShardGroup)shardGroup).clearShards();
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                builder.addShards(Metapb.Shard.newBuilder().setStoreId(shard.getStoreId()).setRole(shard.getStoreId() == leader.getStoreId() ? Metapb.ShardRole.Leader : Metapb.ShardRole.Follower).build());
            }
            this.shardGroupCache.put(partitionId, builder.build());
        }
    }

    public String debugShardGroup() {
        StringBuilder builder = new StringBuilder();
        builder.append("shard group cache:{");
        this.shardGroupCache.forEach((partitionId, shardGroup) -> {
            builder.append(partitionId).append("::{").append("version:").append(shardGroup.getVersion()).append(", conf_version:").append(shardGroup.getConfVer()).append(", state:").append(shardGroup.getState().name()).append(", shards:[");
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                builder.append("{store_id:").append(shard.getStoreId()).append(", role:").append(shard.getRole().name()).append("},");
            }
            builder.append("], ");
        });
        builder.append("}");
        return builder.toString();
    }
}

