#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

"""
    Apache Polaris and Apache Iceberg REST Catalog API

    Defines the specification for the Polaris Catalog API, which encompasses both the Iceberg REST Catalog API and Polaris-native API.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from polaris.catalog.models.attach_policy_request import AttachPolicyRequest
from polaris.catalog.models.create_policy_request import CreatePolicyRequest
from polaris.catalog.models.detach_policy_request import DetachPolicyRequest
from polaris.catalog.models.get_applicable_policies_response import GetApplicablePoliciesResponse
from polaris.catalog.models.list_policies_response import ListPoliciesResponse
from polaris.catalog.models.load_policy_response import LoadPolicyResponse
from polaris.catalog.models.update_policy_request import UpdatePolicyRequest

from polaris.catalog.api_client import ApiClient, RequestSerialized
from polaris.catalog.api_response import ApiResponse
from polaris.catalog.rest import RESTResponseType


class PolicyAPI:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def attach_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        attach_policy_request: AttachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create a mapping between a policy and a resource entity

        Create a mapping between a policy and a resource entity  Policy can be attached to different levels: 1. **Table-like level:** Policies specific to individual tables or views. 2. **Namespace level:** Policies applies to a namespace. 3. **Catalog level:** Policies that applies to a catalog  The ability to attach a policy to a specific entity type is governed by the PolicyValidator. A policy can only be attached if the resource entity is a valid target for the specified policy type.  In addition to the validation rules enforced by the PolicyValidator, there are additional constraints on policy attachment: 1. For inheritable policies, only one policy of the same type can be attached to a given resource entity. 2. For non-inheritable policies, multiple policies of the same type can be attached to the same resource entity without restriction.  For inheritable policies, the inheritance override rule is: 1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies.  Additional parameters can be provided in `parameters` when creating a mapping to define specific behavior or constraints.  If the policy is already attached to the target entity, the existing mapping record will be updated with the new set of parameters, replacing the previous ones. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param attach_policy_request: (required)
        :type attach_policy_request: AttachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._attach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            attach_policy_request=attach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def attach_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        attach_policy_request: AttachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create a mapping between a policy and a resource entity

        Create a mapping between a policy and a resource entity  Policy can be attached to different levels: 1. **Table-like level:** Policies specific to individual tables or views. 2. **Namespace level:** Policies applies to a namespace. 3. **Catalog level:** Policies that applies to a catalog  The ability to attach a policy to a specific entity type is governed by the PolicyValidator. A policy can only be attached if the resource entity is a valid target for the specified policy type.  In addition to the validation rules enforced by the PolicyValidator, there are additional constraints on policy attachment: 1. For inheritable policies, only one policy of the same type can be attached to a given resource entity. 2. For non-inheritable policies, multiple policies of the same type can be attached to the same resource entity without restriction.  For inheritable policies, the inheritance override rule is: 1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies.  Additional parameters can be provided in `parameters` when creating a mapping to define specific behavior or constraints.  If the policy is already attached to the target entity, the existing mapping record will be updated with the new set of parameters, replacing the previous ones. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param attach_policy_request: (required)
        :type attach_policy_request: AttachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._attach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            attach_policy_request=attach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def attach_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        attach_policy_request: AttachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a mapping between a policy and a resource entity

        Create a mapping between a policy and a resource entity  Policy can be attached to different levels: 1. **Table-like level:** Policies specific to individual tables or views. 2. **Namespace level:** Policies applies to a namespace. 3. **Catalog level:** Policies that applies to a catalog  The ability to attach a policy to a specific entity type is governed by the PolicyValidator. A policy can only be attached if the resource entity is a valid target for the specified policy type.  In addition to the validation rules enforced by the PolicyValidator, there are additional constraints on policy attachment: 1. For inheritable policies, only one policy of the same type can be attached to a given resource entity. 2. For non-inheritable policies, multiple policies of the same type can be attached to the same resource entity without restriction.  For inheritable policies, the inheritance override rule is: 1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies.  Additional parameters can be provided in `parameters` when creating a mapping to define specific behavior or constraints.  If the policy is already attached to the target entity, the existing mapping record will be updated with the new set of parameters, replacing the previous ones. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param attach_policy_request: (required)
        :type attach_policy_request: AttachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._attach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            attach_policy_request=attach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _attach_policy_serialize(
        self,
        prefix,
        namespace,
        policy_name,
        attach_policy_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        if policy_name is not None:
            _path_params['policy-name'] = policy_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if attach_policy_request is not None:
            _body_params = attach_policy_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}/mappings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        create_policy_request: CreatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LoadPolicyResponse:
        """Create a policy in the given namespace

        Creates a policy within the specified namespace.  A policy defines a set of rules governing actions on specified resources under predefined conditions. In Apache Polaris, policies are created, stored, and later referenced by external engines to enforce access controls on associated resources.  User provides the following inputs when creating a policy - `name` (REQUIRED): The name of the policy. - `type` (REQUIRED): The type of the policy.   - **Predefined Policies:** policies have a `system.*` prefix in their type, such as `system.data_compaction` - `description` (OPTIONAL): Provides details about the policy's purpose and functionality - `content` (OPTIONAL): Defines the rules that control actions and access conditions on resources. The format can be JSON, SQL, or any other format.  The content field in the request body is validated using the policy's corresponding validator. The policy is created only if the content passes validation.  Upon successful creation, the new policy's version will be 0. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param create_policy_request: (required)
        :type create_policy_request: CreatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            create_policy_request=create_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        create_policy_request: CreatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LoadPolicyResponse]:
        """Create a policy in the given namespace

        Creates a policy within the specified namespace.  A policy defines a set of rules governing actions on specified resources under predefined conditions. In Apache Polaris, policies are created, stored, and later referenced by external engines to enforce access controls on associated resources.  User provides the following inputs when creating a policy - `name` (REQUIRED): The name of the policy. - `type` (REQUIRED): The type of the policy.   - **Predefined Policies:** policies have a `system.*` prefix in their type, such as `system.data_compaction` - `description` (OPTIONAL): Provides details about the policy's purpose and functionality - `content` (OPTIONAL): Defines the rules that control actions and access conditions on resources. The format can be JSON, SQL, or any other format.  The content field in the request body is validated using the policy's corresponding validator. The policy is created only if the content passes validation.  Upon successful creation, the new policy's version will be 0. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param create_policy_request: (required)
        :type create_policy_request: CreatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            create_policy_request=create_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        create_policy_request: CreatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a policy in the given namespace

        Creates a policy within the specified namespace.  A policy defines a set of rules governing actions on specified resources under predefined conditions. In Apache Polaris, policies are created, stored, and later referenced by external engines to enforce access controls on associated resources.  User provides the following inputs when creating a policy - `name` (REQUIRED): The name of the policy. - `type` (REQUIRED): The type of the policy.   - **Predefined Policies:** policies have a `system.*` prefix in their type, such as `system.data_compaction` - `description` (OPTIONAL): Provides details about the policy's purpose and functionality - `content` (OPTIONAL): Defines the rules that control actions and access conditions on resources. The format can be JSON, SQL, or any other format.  The content field in the request body is validated using the policy's corresponding validator. The policy is created only if the content passes validation.  Upon successful creation, the new policy's version will be 0. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param create_policy_request: (required)
        :type create_policy_request: CreatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            create_policy_request=create_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_policy_serialize(
        self,
        prefix,
        namespace,
        create_policy_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_policy_request is not None:
            _body_params = create_policy_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def detach_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_policy_request: DetachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove a mapping between a policy and a target entity

        Remove a mapping between a policy and a target entity  A target entity can be a catalog, namespace, table or view. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_policy_request: (required)
        :type detach_policy_request: DetachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._detach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_policy_request=detach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def detach_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_policy_request: DetachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove a mapping between a policy and a target entity

        Remove a mapping between a policy and a target entity  A target entity can be a catalog, namespace, table or view. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_policy_request: (required)
        :type detach_policy_request: DetachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._detach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_policy_request=detach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def detach_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_policy_request: DetachPolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove a mapping between a policy and a target entity

        Remove a mapping between a policy and a target entity  A target entity can be a catalog, namespace, table or view. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_policy_request: (required)
        :type detach_policy_request: DetachPolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._detach_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_policy_request=detach_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _detach_policy_serialize(
        self,
        prefix,
        namespace,
        policy_name,
        detach_policy_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        if policy_name is not None:
            _path_params['policy-name'] = policy_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if detach_policy_request is not None:
            _body_params = detach_policy_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}/mappings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def drop_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_all: Annotated[Optional[StrictBool], Field(description="When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Drop a policy from the catalog

        Remove a policy from the catalog.   A policy can only be dropped if it is not attached to any resource entity. To remove the policy along with all its attachments, set detach-all to true. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_all: When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. 
        :type detach_all: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._drop_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_all=detach_all,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def drop_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_all: Annotated[Optional[StrictBool], Field(description="When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Drop a policy from the catalog

        Remove a policy from the catalog.   A policy can only be dropped if it is not attached to any resource entity. To remove the policy along with all its attachments, set detach-all to true. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_all: When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. 
        :type detach_all: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._drop_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_all=detach_all,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def drop_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        detach_all: Annotated[Optional[StrictBool], Field(description="When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Drop a policy from the catalog

        Remove a policy from the catalog.   A policy can only be dropped if it is not attached to any resource entity. To remove the policy along with all its attachments, set detach-all to true. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param detach_all: When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. 
        :type detach_all: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._drop_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            detach_all=detach_all,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _drop_policy_serialize(
        self,
        prefix,
        namespace,
        policy_name,
        detach_all,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        if policy_name is not None:
            _path_params['policy-name'] = policy_name
        # process the query parameters
        if detach_all is not None:
            
            _query_params.append(('detach-all', detach_all))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_applicable_policies(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        namespace: Annotated[Optional[StrictStr], Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")] = None,
        target_name: Annotated[Optional[StrictStr], Field(description="Name of the target table/view")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetApplicablePoliciesResponse:
        """Get Applicable policies for catalog, namespace, table, or views

        Retrieves all applicable policies for a specified entity, including inherited policies from parent entities. An entity can be a table/view, namespace, or catalog. The required parameters depend on the entity type:  - Table/View:   - The `namespace` parameter is required to specify the entity's namespace.   - The `target-name` parameter is required to specify the entity name. - Namespace:   - The `namespace` parameter is required to specify the identifier.   - The `target-name` parameter should not be set. - Catalog:   - Neither `namespace` nor `target-name` should be set.  An optional policyType parameter filters results to return only policies of the specified type.  This API evaluates the entity's hierarchy and applies inheritable policies from parent entities. The inheritance follows the following override rule:  1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.
        :type namespace: str
        :param target_name: Name of the target table/view
        :type target_name: str
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_policies_serialize(
            prefix=prefix,
            page_token=page_token,
            page_size=page_size,
            namespace=namespace,
            target_name=target_name,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetApplicablePoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_applicable_policies_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        namespace: Annotated[Optional[StrictStr], Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")] = None,
        target_name: Annotated[Optional[StrictStr], Field(description="Name of the target table/view")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetApplicablePoliciesResponse]:
        """Get Applicable policies for catalog, namespace, table, or views

        Retrieves all applicable policies for a specified entity, including inherited policies from parent entities. An entity can be a table/view, namespace, or catalog. The required parameters depend on the entity type:  - Table/View:   - The `namespace` parameter is required to specify the entity's namespace.   - The `target-name` parameter is required to specify the entity name. - Namespace:   - The `namespace` parameter is required to specify the identifier.   - The `target-name` parameter should not be set. - Catalog:   - Neither `namespace` nor `target-name` should be set.  An optional policyType parameter filters results to return only policies of the specified type.  This API evaluates the entity's hierarchy and applies inheritable policies from parent entities. The inheritance follows the following override rule:  1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.
        :type namespace: str
        :param target_name: Name of the target table/view
        :type target_name: str
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_policies_serialize(
            prefix=prefix,
            page_token=page_token,
            page_size=page_size,
            namespace=namespace,
            target_name=target_name,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetApplicablePoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_applicable_policies_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        namespace: Annotated[Optional[StrictStr], Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")] = None,
        target_name: Annotated[Optional[StrictStr], Field(description="Name of the target table/view")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Applicable policies for catalog, namespace, table, or views

        Retrieves all applicable policies for a specified entity, including inherited policies from parent entities. An entity can be a table/view, namespace, or catalog. The required parameters depend on the entity type:  - Table/View:   - The `namespace` parameter is required to specify the entity's namespace.   - The `target-name` parameter is required to specify the entity name. - Namespace:   - The `namespace` parameter is required to specify the identifier.   - The `target-name` parameter should not be set. - Catalog:   - Neither `namespace` nor `target-name` should be set.  An optional policyType parameter filters results to return only policies of the specified type.  This API evaluates the entity's hierarchy and applies inheritable policies from parent entities. The inheritance follows the following override rule:  1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.
        :type namespace: str
        :param target_name: Name of the target table/view
        :type target_name: str
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_policies_serialize(
            prefix=prefix,
            page_token=page_token,
            page_size=page_size,
            namespace=namespace,
            target_name=target_name,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetApplicablePoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_applicable_policies_serialize(
        self,
        prefix,
        page_token,
        page_size,
        namespace,
        target_name,
        policy_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        # process the query parameters
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        if target_name is not None:
            
            _query_params.append(('target-name', target_name))
            
        if policy_type is not None:
            
            _query_params.append(('policyType', policy_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/polaris/v1/{prefix}/applicable-policies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_policies(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListPoliciesResponse:
        """List all policy identifiers underneath a given namespace

        Return all policy identifiers under this namespace. Users can optionally filter the result by policy type

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_policies_serialize(
            prefix=prefix,
            namespace=namespace,
            page_token=page_token,
            page_size=page_size,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListPoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_policies_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListPoliciesResponse]:
        """List all policy identifiers underneath a given namespace

        Return all policy identifiers under this namespace. Users can optionally filter the result by policy type

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_policies_serialize(
            prefix=prefix,
            namespace=namespace,
            page_token=page_token,
            page_size=page_size,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListPoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_policies_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        page_token: Optional[StrictStr] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.")] = None,
        policy_type: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List all policy identifiers underneath a given namespace

        Return all policy identifiers under this namespace. Users can optionally filter the result by policy type

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param page_token:
        :type page_token: str
        :param page_size: For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated `pageSize`.
        :type page_size: int
        :param policy_type:
        :type policy_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_policies_serialize(
            prefix=prefix,
            namespace=namespace,
            page_token=page_token,
            page_size=page_size,
            policy_type=policy_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListPoliciesResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_policies_serialize(
        self,
        prefix,
        namespace,
        page_token,
        page_size,
        policy_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        # process the query parameters
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if policy_type is not None:
            
            _query_params.append(('policyType', policy_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def load_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LoadPolicyResponse:
        """Load a policy

        Load a policy from the catalog  The response contains the policy's metadata and content. For more details, refer to the definition of the `Policy` model. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def load_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LoadPolicyResponse]:
        """Load a policy

        Load a policy from the catalog  The response contains the policy's metadata and content. For more details, refer to the definition of the `Policy` model. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def load_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Load a policy

        Load a policy from the catalog  The response contains the policy's metadata and content. For more details, refer to the definition of the `Policy` model. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _load_policy_serialize(
        self,
        prefix,
        namespace,
        policy_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        if policy_name is not None:
            _path_params['policy-name'] = policy_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_policy(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        update_policy_request: UpdatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LoadPolicyResponse:
        """Update a policy

        Update a policy  A policy's description and content can be updated. The new content is validated against the policy's corresponding validator. Upon a successful update, the policy's version is incremented by 1.  The update will only succeed if the current version matches the one in the catalog. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param update_policy_request: (required)
        :type update_policy_request: UpdatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            update_policy_request=update_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_policy_with_http_info(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        update_policy_request: UpdatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LoadPolicyResponse]:
        """Update a policy

        Update a policy  A policy's description and content can be updated. The new content is validated against the policy's corresponding validator. Upon a successful update, the policy's version is incremented by 1.  The update will only succeed if the current version matches the one in the catalog. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param update_policy_request: (required)
        :type update_policy_request: UpdatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            update_policy_request=update_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_policy_without_preload_content(
        self,
        prefix: Annotated[StrictStr, Field(description="An optional prefix in the path")],
        namespace: Annotated[StrictStr, Field(description="A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte.")],
        policy_name: Annotated[str, Field(strict=True)],
        update_policy_request: UpdatePolicyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a policy

        Update a policy  A policy's description and content can be updated. The new content is validated against the policy's corresponding validator. Upon a successful update, the policy's version is incremented by 1.  The update will only succeed if the current version matches the one in the catalog. 

        :param prefix: An optional prefix in the path (required)
        :type prefix: str
        :param namespace: A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (`0x1F`) byte. (required)
        :type namespace: str
        :param policy_name: (required)
        :type policy_name: str
        :param update_policy_request: (required)
        :type update_policy_request: UpdatePolicyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_policy_serialize(
            prefix=prefix,
            namespace=namespace,
            policy_name=policy_name,
            update_policy_request=update_policy_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LoadPolicyResponse",
            '400': "IcebergErrorResponse",
            '401': "IcebergErrorResponse",
            '403': "IcebergErrorResponse",
            '404': "IcebergErrorResponse",
            '409': "IcebergErrorResponse",
            '503': "IcebergErrorResponse",
            '5XX': "IcebergErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_policy_serialize(
        self,
        prefix,
        namespace,
        policy_name,
        update_policy_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if prefix is not None:
            _path_params['prefix'] = prefix
        if namespace is not None:
            _path_params['namespace'] = namespace
        if policy_name is not None:
            _path_params['policy-name'] = policy_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_policy_request is not None:
            _body_params = update_policy_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


