/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;

public class ListEntitiesResult
extends BaseResult {
    private final List<EntityNameLookupRecord> entities;
    private final Optional<PageToken> pageTokenOpt;

    public static ListEntitiesResult fromPage(Page<EntityNameLookupRecord> page) {
        return new ListEntitiesResult(page.items, Optional.ofNullable(page.pageToken));
    }

    public ListEntitiesResult(@Nonnull BaseResult.ReturnStatus errorCode, @Nullable String extraInformation, @Nonnull Optional<PageToken> pageTokenOpt) {
        super(errorCode, extraInformation);
        this.entities = null;
        this.pageTokenOpt = pageTokenOpt;
    }

    public ListEntitiesResult(@Nonnull List<EntityNameLookupRecord> entities, @Nonnull Optional<PageToken> pageTokenOpt) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.entities = entities;
        this.pageTokenOpt = pageTokenOpt;
    }

    @JsonCreator
    private ListEntitiesResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") String extraInformation, @JsonProperty(value="entities") List<EntityNameLookupRecord> entities, @JsonProperty(value="pageToken") Optional<PageToken> pageTokenOpt) {
        super(returnStatus, extraInformation);
        this.entities = entities;
        this.pageTokenOpt = pageTokenOpt;
    }

    public List<EntityNameLookupRecord> getEntities() {
        return this.entities;
    }

    public Optional<PageToken> getPageToken() {
        return this.pageTokenOpt;
    }
}

