/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.EntityAlreadyExistsException;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;

public abstract class AbstractTransactionalPersistence
implements TransactionalPersistence {
    @Nullable
    protected abstract EntityNameLookupRecord lookupEntityActiveInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntitiesActiveKey var2);

    protected abstract void writeToEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);

    protected abstract void writeToEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);

    protected abstract void writeToEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);

    protected abstract void deleteFromEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntityCore var2);

    protected abstract void deleteFromEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntityCore var2);

    protected abstract void deleteFromEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntityCore var2);

    @Override
    public long generateNewId(@Nonnull PolarisCallContext callCtx) {
        return this.runInTransaction(callCtx, () -> this.generateNewIdInCurrentTxn(callCtx));
    }

    private void checkConditionsForWriteEntityInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nullable PolarisBaseEntity originalEntity) {
        PolarisBaseEntity refreshedEntity = this.lookupEntityInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        if (originalEntity == null) {
            if (refreshedEntity != null) {
                throw new EntityAlreadyExistsException(refreshedEntity);
            }
            refreshedEntity = this.lookupEntityByNameInCurrentTxn(callCtx, entity.getCatalogId(), entity.getParentId(), entity.getType().getCode(), entity.getName());
            if (refreshedEntity != null) {
                throw new EntityAlreadyExistsException(refreshedEntity);
            }
        } else if (refreshedEntity == null || refreshedEntity.getEntityVersion() != originalEntity.getEntityVersion() || refreshedEntity.getGrantRecordsVersion() != originalEntity.getGrantRecordsVersion()) {
            throw new RetryOnConcurrencyException("Entity '%s' id '%s' concurrently modified; expected version %s/%s got %s/%s", entity.getName(), entity.getId(), originalEntity.getEntityVersion(), originalEntity.getGrantRecordsVersion(), refreshedEntity != null ? refreshedEntity.getEntityVersion() : -1, refreshedEntity != null ? refreshedEntity.getGrantRecordsVersion() : -1);
        }
    }

    @Override
    public void writeEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nullable PolarisBaseEntity originalEntity) {
        this.runActionInTransaction(callCtx, () -> {
            this.checkConditionsForWriteEntityInCurrentTxn(callCtx, entity, originalEntity);
            this.writeEntityInCurrentTxn(callCtx, entity, nameOrParentChanged, originalEntity);
        });
    }

    @Override
    public void writeEntities(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisBaseEntity> entities, @Nullable List<PolarisBaseEntity> originalEntities) {
        if (originalEntities != null) {
            callCtx.getDiagServices().check(entities.size() == originalEntities.size(), "mismatched_entities_and_original_entities_size", "entities.size()={}, originalEntities.size()={}", entities.size(), originalEntities.size());
        }
        this.runActionInTransaction(callCtx, () -> {
            for (int i = 0; i < entities.size(); ++i) {
                boolean nameOrParentChanged;
                PolarisBaseEntity originalEntity;
                PolarisBaseEntity entity;
                block3: {
                    entity = (PolarisBaseEntity)entities.get(i);
                    originalEntity = originalEntities != null ? (PolarisBaseEntity)originalEntities.get(i) : null;
                    nameOrParentChanged = originalEntity == null || !entity.getName().equals(originalEntity.getName()) || entity.getParentId() != originalEntity.getParentId();
                    try {
                        this.checkConditionsForWriteEntityInCurrentTxn(callCtx, entity, originalEntity);
                    }
                    catch (EntityAlreadyExistsException e) {
                        if (e.getExistingEntity().getId() == entity.getId()) break block3;
                        throw e;
                    }
                }
                this.writeEntityInCurrentTxn(callCtx, entity, nameOrParentChanged, originalEntity);
            }
        });
    }

    @Override
    public void writeToGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.runActionInTransaction(callCtx, () -> this.writeToGrantRecordsInCurrentTxn(callCtx, grantRec));
    }

    @Override
    public void deleteEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.runActionInTransaction(callCtx, () -> this.deleteEntityInCurrentTxn(callCtx, entity));
    }

    @Override
    public void deleteFromGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.runActionInTransaction(callCtx, () -> this.deleteFromGrantRecordsInCurrentTxn(callCtx, grantRec));
    }

    @Override
    public void deleteAllEntityGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity, @Nonnull List<PolarisGrantRecord> grantsOnGrantee, @Nonnull List<PolarisGrantRecord> grantsOnSecurable) {
        this.runActionInTransaction(callCtx, () -> this.deleteAllEntityGrantRecordsInCurrentTxn(callCtx, entity, grantsOnGrantee, grantsOnSecurable));
    }

    @Override
    public void deleteAll(@Nonnull PolarisCallContext callCtx) {
        this.runActionInTransaction(callCtx, () -> this.deleteAllInCurrentTxn(callCtx));
    }

    @Override
    @Nullable
    public PolarisBaseEntity lookupEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, int typeCode) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntityInCurrentTxn(callCtx, catalogId, entityId, typeCode));
    }

    @Override
    @Nullable
    public PolarisBaseEntity lookupEntityByName(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntityByNameInCurrentTxn(callCtx, catalogId, parentId, typeCode, name));
    }

    @Override
    @Nullable
    public EntityNameLookupRecord lookupEntityIdAndSubTypeByName(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, catalogId, parentId, typeCode, name));
    }

    @Override
    @Nonnull
    public List<PolarisBaseEntity> lookupEntities(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntitiesInCurrentTxn(callCtx, entityIds));
    }

    @Override
    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersions(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntityVersionsInCurrentTxn(callCtx, entityIds));
    }

    @Override
    @Nonnull
    public Page<EntityNameLookupRecord> listEntities(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PageToken pageToken) {
        return this.runInReadTransaction(callCtx, () -> this.listEntitiesInCurrentTxn(callCtx, catalogId, parentId, entityType, pageToken));
    }

    @Override
    @Nonnull
    public Page<EntityNameLookupRecord> listEntities(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull Predicate<PolarisBaseEntity> entityFilter, @Nonnull PageToken pageToken) {
        return this.runInReadTransaction(callCtx, () -> this.listEntitiesInCurrentTxn(callCtx, catalogId, parentId, entityType, entityFilter, pageToken));
    }

    @Override
    @Nonnull
    public <T> Page<T> listEntities(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull Predicate<PolarisBaseEntity> entityFilter, @Nonnull Function<PolarisBaseEntity, T> transformer, @Nonnull PageToken pageToken) {
        return this.runInReadTransaction(callCtx, () -> this.listEntitiesInCurrentTxn(callCtx, catalogId, parentId, entityType, entityFilter, transformer, pageToken));
    }

    @Override
    public int lookupEntityGrantRecordsVersion(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId) {
        return this.runInReadTransaction(callCtx, () -> this.lookupEntityGrantRecordsVersionInCurrentTxn(callCtx, catalogId, entityId));
    }

    @Override
    @Nullable
    public PolarisGrantRecord lookupGrantRecord(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId, long granteeCatalogId, long granteeId, int privilegeCode) {
        return this.runInReadTransaction(callCtx, () -> this.lookupGrantRecordInCurrentTxn(callCtx, securableCatalogId, securableId, granteeCatalogId, granteeId, privilegeCode));
    }

    @Override
    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurable(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        return this.runInReadTransaction(callCtx, () -> this.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, securableCatalogId, securableId));
    }

    @Override
    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGrantee(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        return this.runInReadTransaction(callCtx, () -> this.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, granteeCatalogId, granteeId));
    }

    @Override
    public boolean hasChildren(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityType optionalEntityType, long catalogId, long parentId) {
        return this.runInReadTransaction(callCtx, () -> this.hasChildrenInCurrentTxn(callCtx, optionalEntityType, catalogId, parentId));
    }

    @Override
    @Nullable
    public PolarisPrincipalSecrets loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        return this.runInReadTransaction(callCtx, () -> this.loadPrincipalSecretsInCurrentTxn(callCtx, clientId));
    }

    @Override
    @Nonnull
    public PolarisPrincipalSecrets generateNewPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String principalName, long principalId) {
        return this.runInTransaction(callCtx, () -> this.generateNewPrincipalSecretsInCurrentTxn(callCtx, principalName, principalId));
    }

    @Override
    @Nullable
    public PolarisPrincipalSecrets rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        return this.runInTransaction(callCtx, () -> this.rotatePrincipalSecretsInCurrentTxn(callCtx, clientId, principalId, reset, oldSecretHash));
    }

    @Override
    public void deletePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        this.runActionInTransaction(callCtx, () -> this.deletePrincipalSecretsInCurrentTxn(callCtx, clientId, principalId));
    }

    @Override
    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> createStorageIntegration(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        return this.runInTransaction(callCtx, () -> this.createStorageIntegrationInCurrentTxn(callCtx, catalogId, entityId, polarisStorageConfigurationInfo));
    }

    @Override
    public <T extends PolarisStorageConfigurationInfo> void persistStorageIntegrationIfNeeded(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nullable PolarisStorageIntegration<T> storageIntegration) {
        this.runActionInTransaction(callCtx, () -> this.persistStorageIntegrationIfNeededInCurrentTxn(callCtx, entity, storageIntegration));
    }

    @Override
    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> loadPolarisStorageIntegration(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        return this.runInReadTransaction(callCtx, () -> this.loadPolarisStorageIntegrationInCurrentTxn(callCtx, entity));
    }

    @Override
    public void writeEntityInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nullable PolarisBaseEntity originalEntity) {
        this.writeToEntitiesInCurrentTxn(callCtx, entity);
        this.writeToEntitiesChangeTrackingInCurrentTxn(callCtx, entity);
        if (nameOrParentChanged) {
            if (originalEntity != null) {
                this.deleteFromEntitiesActiveInCurrentTxn(callCtx, originalEntity);
            }
            this.writeToEntitiesActiveInCurrentTxn(callCtx, entity);
        }
    }

    @Override
    public void writeEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisBaseEntity> entities, @Nullable List<PolarisBaseEntity> originalEntities) {
        if (originalEntities != null) {
            callCtx.getDiagServices().check(entities.size() == originalEntities.size(), "mismatched_entities_and_original_entities_size", "entities.size()={}, originalEntities.size()={}", entities.size(), originalEntities.size());
        }
        for (int i = 0; i < entities.size(); ++i) {
            PolarisBaseEntity entity = entities.get(i);
            PolarisBaseEntity originalEntity = originalEntities != null ? originalEntities.get(i) : null;
            boolean nameOrParentChanged = originalEntity == null || !entity.getName().equals(originalEntity.getName()) || entity.getParentId() != originalEntity.getParentId();
            this.writeEntityInCurrentTxn(callCtx, entity, nameOrParentChanged, originalEntity);
        }
    }

    @Override
    public void deleteEntityInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.deleteFromEntitiesActiveInCurrentTxn(callCtx, entity);
        this.deleteFromEntitiesInCurrentTxn(callCtx, entity);
        this.deleteFromEntitiesChangeTrackingInCurrentTxn(callCtx, entity);
    }

    @Override
    @Nullable
    public PolarisBaseEntity lookupEntityByNameInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        PolarisEntitiesActiveKey entityActiveKey = new PolarisEntitiesActiveKey(catalogId, parentId, typeCode, name);
        EntityNameLookupRecord entityActiveRecord = this.lookupEntityActiveInCurrentTxn(callCtx, entityActiveKey);
        if (entityActiveRecord == null) {
            return null;
        }
        PolarisBaseEntity entity = this.lookupEntityInCurrentTxn(callCtx, entityActiveRecord.getCatalogId(), entityActiveRecord.getId(), entityActiveRecord.getTypeCode());
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_not_found_entity", "entityActiveRecord={}", entityActiveRecord);
        return entity;
    }

    @Override
    @Nullable
    public EntityNameLookupRecord lookupEntityIdAndSubTypeByNameInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        PolarisEntitiesActiveKey entityActiveKey = new PolarisEntitiesActiveKey(catalogId, parentId, typeCode, name);
        return this.lookupEntityActiveInCurrentTxn(callCtx, entityActiveKey);
    }

    @Override
    public void writeToPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.runActionInTransaction(callCtx, () -> {
            this.checkConditionsForWriteToPolicyMappingRecordsInCurrentTxn(callCtx, record);
            this.writeToPolicyMappingRecordsInCurrentTxn(callCtx, record);
        });
    }

    @Override
    public void checkConditionsForWriteToPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        PolarisPolicyMappingRecord existingRecord;
        PolicyType policyType = PolicyType.fromCode(record.getPolicyTypeCode());
        Preconditions.checkArgument((policyType != null ? 1 : 0) != 0, (String)"Invalid policy type code: %s", (int)record.getPolicyTypeCode());
        if (!policyType.isInheritable()) {
            return;
        }
        List<PolarisPolicyMappingRecord> existingRecords = this.loadPoliciesOnTargetByTypeInCurrentTxn(callCtx, record.getTargetCatalogId(), record.getTargetId(), record.getPolicyTypeCode());
        if (existingRecords.size() > 1) {
            throw new PolicyMappingAlreadyExistsException(existingRecords.get(0));
        }
        if (existingRecords.size() == 1 && ((existingRecord = existingRecords.get(0)).getPolicyCatalogId() != record.getPolicyCatalogId() || existingRecord.getPolicyId() != record.getPolicyId())) {
            throw new PolicyMappingAlreadyExistsException(existingRecord);
        }
    }

    @Override
    public void deleteFromPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.runActionInTransaction(callCtx, () -> this.deleteFromPolicyMappingRecordsInCurrentTxn(callCtx, record));
    }

    @Override
    public void deleteAllEntityPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nonnull List<PolarisPolicyMappingRecord> mappingOnTarget, @Nonnull List<PolarisPolicyMappingRecord> mappingOnPolicy) {
        this.runActionInTransaction(callCtx, () -> this.deleteAllEntityPolicyMappingRecordsInCurrentTxn(callCtx, entity, mappingOnTarget, mappingOnPolicy));
    }

    @Override
    @Nullable
    public PolarisPolicyMappingRecord lookupPolicyMappingRecord(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode, long policyCatalogId, long policyId) {
        return this.runInReadTransaction(callCtx, () -> this.lookupPolicyMappingRecordInCurrentTxn(callCtx, targetCatalogId, targetId, policyTypeCode, policyCatalogId, policyId));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadPoliciesOnTargetByType(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode) {
        return this.runInReadTransaction(callCtx, () -> this.loadPoliciesOnTargetByTypeInCurrentTxn(callCtx, targetCatalogId, targetId, policyTypeCode));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllPoliciesOnTarget(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId) {
        return this.runInReadTransaction(callCtx, () -> this.loadAllPoliciesOnTargetInCurrentTxn(callCtx, targetCatalogId, targetId));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllTargetsOnPolicy(@Nonnull PolarisCallContext callCtx, long policyCatalogId, long policyId, int policyTypeCode) {
        return this.runInReadTransaction(callCtx, () -> this.loadAllTargetsOnPolicyInCurrentTxn(callCtx, policyCatalogId, policyId, policyTypeCode));
    }
}

