/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.generic;

import jakarta.ws.rs.core.SecurityContext;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.table.GenericTableEntity;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.catalog.generic.GenericTableCatalog;
import org.apache.polaris.service.catalog.generic.PolarisGenericTableCatalog;
import org.apache.polaris.service.types.GenericTable;
import org.apache.polaris.service.types.ListGenericTablesResponse;
import org.apache.polaris.service.types.LoadGenericTableResponse;

public class GenericTableCatalogHandler
extends CatalogHandler {
    private PolarisMetaStoreManager metaStoreManager;
    private GenericTableCatalog genericTableCatalog;

    public GenericTableCatalogHandler(CallContext callContext, PolarisEntityManager entityManager, PolarisMetaStoreManager metaStoreManager, SecurityContext securityContext, String catalogName, PolarisAuthorizer authorizer) {
        super(callContext, entityManager, securityContext, catalogName, authorizer);
        this.metaStoreManager = metaStoreManager;
    }

    @Override
    protected void initializeCatalog() {
        this.genericTableCatalog = new PolarisGenericTableCatalog(this.metaStoreManager, this.callContext, (PolarisResolutionManifestCatalogView)this.resolutionManifest);
        this.genericTableCatalog.initialize(this.catalogName, Map.of());
    }

    public ListGenericTablesResponse listGenericTables(Namespace parent) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        return ListGenericTablesResponse.builder().setIdentifiers(new LinkedHashSet<TableIdentifier>(this.genericTableCatalog.listGenericTables(parent))).build();
    }

    public LoadGenericTableResponse createGenericTable(TableIdentifier identifier, String format, String doc, Map<String, String> properties) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_DIRECT;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, identifier);
        GenericTableEntity createdEntity = this.genericTableCatalog.createGenericTable(identifier, format, doc, properties);
        GenericTable createdTable = GenericTable.builder().setName(createdEntity.getName()).setFormat(createdEntity.getFormat()).setDoc(createdEntity.getDoc()).setProperties(createdEntity.getPropertiesAsMap()).build();
        return LoadGenericTableResponse.builder().setTable(createdTable).build();
    }

    public boolean dropGenericTable(TableIdentifier identifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITHOUT_PURGE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, identifier);
        return this.genericTableCatalog.dropGenericTable(identifier);
    }

    public LoadGenericTableResponse loadGenericTable(TableIdentifier identifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_TABLE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.GENERIC_TABLE, identifier);
        GenericTableEntity loadedEntity = this.genericTableCatalog.loadGenericTable(identifier);
        GenericTable loadedTable = GenericTable.builder().setName(loadedEntity.getName()).setFormat(loadedEntity.getFormat()).setDoc(loadedEntity.getDoc()).setProperties(loadedEntity.getPropertiesAsMap()).build();
        return LoadGenericTableResponse.builder().setTable(loadedTable).build();
    }
}

