/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.Map;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.service.context.CallContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="default")
public class DefaultCallContextResolver
implements CallContextResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCallContextResolver.class);
    @Inject
    MetaStoreManagerFactory metaStoreManagerFactory;
    @Inject
    PolarisConfigurationStore configurationStore;
    @Inject
    PolarisDiagnostics diagnostics;
    @Inject
    Clock clock;

    @Override
    public CallContext resolveCallContext(RealmContext realmContext, String method, String path, Map<String, String> headers) {
        LOGGER.atDebug().addKeyValue("realmContext", (Object)realmContext.getRealmIdentifier()).addKeyValue("method", (Object)method).addKeyValue("path", (Object)path).addKeyValue("headers", headers).log("Resolving CallContext");
        BasePersistence metaStoreSession = (BasePersistence)this.metaStoreManagerFactory.getOrCreateSessionSupplier(realmContext).get();
        return new PolarisCallContext(realmContext, metaStoreSession, this.diagnostics, this.configurationStore, this.clock);
    }
}

