/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.impl.ImplMessages;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

public class JwtBuildUtils {
    public static final String SIGN_KEY_LOCATION_PROPERTY = "smallrye.jwt.sign.key.location";
    public static final String SIGN_KEY_PROPERTY = "smallrye.jwt.sign.key";
    public static final String SIGN_KEY_ID_PROPERTY = "smallrye.jwt.sign.key.id";
    public static final String SIGN_KEY_RELAX_VALIDATION_PROPERTY = "smallrye.jwt.sign.relax-key-validation";
    public static final String ENC_KEY_LOCATION_PROPERTY = "smallrye.jwt.encrypt.key.location";
    public static final String ENC_KEY_PROPERTY = "smallrye.jwt.encrypt.key";
    public static final String ENC_KEY_ID_PROPERTY = "smallrye.jwt.encrypt.key.id";
    public static final String ENC_KEY_RELAX_VALIDATION_PROPERTY = "smallrye.jwt.encrypt.relax-key-validation";
    public static final String NEW_TOKEN_ISSUER_PROPERTY = "smallrye.jwt.new-token.issuer";
    public static final String NEW_TOKEN_AUDIENCE_PROPERTY = "smallrye.jwt.new-token.audience";
    public static final String NEW_TOKEN_OVERRIDE_CLAIMS_PROPERTY = "smallrye.jwt.new-token.override-matching-claims";
    public static final String NEW_TOKEN_LIFESPAN_PROPERTY = "smallrye.jwt.new-token.lifespan";
    public static final String NEW_TOKEN_SIGNATURE_ALG_PROPERTY = "smallrye.jwt.new-token.signature-algorithm";
    public static final String NEW_TOKEN_KEY_ENCRYPTION_ALG_PROPERTY = "smallrye.jwt.new-token.key-encryption-algorithm";
    public static final String NEW_TOKEN_CONTENT_ENCRYPTION_ALG_PROPERTY = "smallrye.jwt.new-token.content-encryption-algorithm";
    public static final String KEYSTORE_PASSWORD = "smallrye.jwt.keystore.password";
    public static final String KEYSTORE_TYPE = "smallrye.jwt.keystore.type";
    public static final String KEYSTORE_PROVIDER = "smallrye.jwt.keystore.provider";
    public static final String SIGN_KEYSTORE_KEY_ALIAS = "smallrye.jwt.keystore.sign.key.alias";
    public static final String SIGN_KEYSTORE_KEY_PASSWORD = "smallrye.jwt.keystore.sign.key.password";
    public static final String ENC_KEYSTORE_KEY_ALIAS = "smallrye.jwt.keystore.encrypt.key.alias";

    private JwtBuildUtils() {
    }

    static void setDefaultJwtClaims(JwtClaims claims, Long tokenLifespan) {
        String audience;
        String issuer;
        Boolean overrideMatchingClaims;
        if (!claims.hasClaim(Claims.iat.name())) {
            claims.setIssuedAt(NumericDate.fromSeconds((long)JwtBuildUtils.currentTimeInSecs()));
        }
        JwtBuildUtils.setExpiryClaim(claims, tokenLifespan);
        if (!claims.hasClaim(Claims.jti.name())) {
            claims.setClaim(Claims.jti.name(), (Object)UUID.randomUUID().toString());
        }
        if ((Boolean.TRUE.equals(overrideMatchingClaims = JwtBuildUtils.getConfigProperty(NEW_TOKEN_OVERRIDE_CLAIMS_PROPERTY, Boolean.class)) || !claims.hasClaim(Claims.iss.name())) && (issuer = JwtBuildUtils.getConfigProperty(NEW_TOKEN_ISSUER_PROPERTY, String.class)) != null) {
            claims.setIssuer(issuer);
        }
        if ((Boolean.TRUE.equals(overrideMatchingClaims) || !claims.hasClaim(Claims.aud.name())) && (audience = JwtBuildUtils.getConfigProperty(NEW_TOKEN_AUDIENCE_PROPERTY, String.class)) != null) {
            claims.setAudience(audience);
        }
    }

    static <T> T getConfigProperty(String name, Class<T> cls) {
        return JwtBuildUtils.getConfigProperty(name, cls, null);
    }

    static <T> T getConfigProperty(String name, Class<T> cls, T defaultValue) {
        return JwtBuildUtils.getOptionalConfigProperty(name, cls).orElse(defaultValue);
    }

    static <T> Optional<T> getOptionalConfigProperty(String name, Class<T> cls) {
        return ConfigProvider.getConfig().getOptionalValue(name, cls);
    }

    static String readJsonContent(String jsonResName) {
        try {
            String content = ResourceUtils.readResource((String)jsonResName);
            if (content == null) {
                throw ImplMessages.msg.failureToOpenInputStreamFromJsonResName(jsonResName);
            }
            return content;
        }
        catch (IOException ex) {
            throw ImplMessages.msg.failureToReadJsonContentFromJsonResName(jsonResName, ex.getMessage(), ex);
        }
    }

    static JwtClaims convertToClaims(Map<String, Object> claimsMap) {
        JwtClaims claims = new JwtClaims();
        JwtBuildUtils.convertToClaims(claims, claimsMap);
        return claims;
    }

    static void convertToClaims(JwtClaims claims, Map<String, Object> claimsMap) {
        for (Map.Entry<String, Object> entry : claimsMap.entrySet()) {
            claims.setClaim(entry.getKey(), entry.getValue());
        }
    }

    static int currentTimeInSecs() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private static void setExpiryClaim(JwtClaims claims, Long tokenLifespan) {
        if (!claims.hasClaim(Claims.exp.name())) {
            Object value = claims.getClaimValue(Claims.iat.name());
            Long issuedAt = value instanceof NumericDate ? ((NumericDate)value).getValue() : ((Long)value).longValue();
            Long lifespan = tokenLifespan;
            if (lifespan == null) {
                lifespan = JwtBuildUtils.getConfigProperty(NEW_TOKEN_LIFESPAN_PROPERTY, Long.class, 300L);
            }
            claims.setExpirationTime(NumericDate.fromSeconds((long)(issuedAt + lifespan)));
        }
    }

    static JwtClaims parseJwtClaims(String jwtLocation) {
        try {
            return JwtClaims.parse((String)JwtBuildUtils.readJsonContent(jwtLocation));
        }
        catch (Exception ex) {
            throw ImplMessages.msg.failureToParseJWTClaims(ex.getMessage(), ex);
        }
    }

    static JwtClaims parseJwtContent(String jwtContent) {
        try {
            return JwtClaims.parse((String)jwtContent);
        }
        catch (Exception ex) {
            throw ImplMessages.msg.failureToParseJWTClaims(ex.getMessage(), ex);
        }
    }

    static PrivateKey readPrivateKeyFromKeystore(String keyStorePath) {
        Optional<String> signKeyStoreKeyAlias;
        Optional<String> keyStorePassword = JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_PASSWORD, String.class);
        if (keyStorePassword.isPresent() && (signKeyStoreKeyAlias = JwtBuildUtils.getOptionalConfigProperty(SIGN_KEYSTORE_KEY_ALIAS, String.class)).isPresent()) {
            try {
                KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)keyStorePassword.get(), JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_TYPE, String.class), JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_PROVIDER, String.class));
                return (PrivateKey)keyStore.getKey(signKeyStoreKeyAlias.get(), JwtBuildUtils.getOptionalConfigProperty(SIGN_KEYSTORE_KEY_PASSWORD, String.class).orElse(keyStorePassword.get()).toCharArray());
            }
            catch (Exception ex) {
                throw ImplMessages.msg.signingKeyCanNotBeReadFromKeystore(ex);
            }
        }
        return null;
    }

    static PublicKey readPublicKeyFromKeystore(String keyStorePath) {
        Optional<String> encKeyStoreKeyAlias;
        Optional<String> keyStorePassword = JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_PASSWORD, String.class);
        if (keyStorePassword.isPresent() && (encKeyStoreKeyAlias = JwtBuildUtils.getOptionalConfigProperty(ENC_KEYSTORE_KEY_ALIAS, String.class)).isPresent()) {
            try {
                KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)keyStorePassword.get(), JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_TYPE, String.class), JwtBuildUtils.getOptionalConfigProperty(KEYSTORE_PROVIDER, String.class));
                return keyStore.getCertificate(encKeyStoreKeyAlias.get()).getPublicKey();
            }
            catch (Exception ex) {
                throw ImplMessages.msg.encryptionKeyCanNotBeReadFromKeystore(ex);
            }
        }
        return null;
    }
}

