/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

final class Substitutions {
    Substitutions() {
    }

    @TargetClass(className="com.oracle.svm.core.jdk.SystemPropertiesSupport", onlyWith={SystemPropertiesSupportGetCurrentPropertiesPresent.class})
    static final class Target_SystemPropertiesSupport_post_21 {
        @Alias
        private Properties currentProperties;

        Target_SystemPropertiesSupport_post_21() {
        }

        @Alias
        private void ensureAllPropertiesInitialized() {
        }

        @Alias
        private void ensurePropertyInitialized(String key) {
        }

        @Substitute
        public Properties getCurrentProperties() {
            return new Properties(){

                @Override
                public synchronized Object setProperty(String key, String value) {
                    this.ensurePropertyInitialized(key);
                    return currentProperties.setProperty(key, value);
                }

                @Override
                public synchronized void load(Reader reader) throws IOException {
                    currentProperties.load(reader);
                }

                @Override
                public synchronized void load(InputStream inStream) throws IOException {
                    currentProperties.load(inStream);
                }

                @Override
                public void save(OutputStream out, String comments) {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.save(out, comments);
                }

                @Override
                public void store(Writer writer, String comments) throws IOException {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.store(writer, comments);
                }

                @Override
                public void store(OutputStream out, String comments) throws IOException {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.store(out, comments);
                }

                @Override
                public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
                    currentProperties.loadFromXML(in);
                }

                @Override
                public void storeToXML(OutputStream os, String comment) throws IOException {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.storeToXML(os, comment);
                }

                @Override
                public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.storeToXML(os, comment, encoding);
                }

                @Override
                public void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.storeToXML(os, comment, charset);
                }

                @Override
                public String getProperty(String key) {
                    this.ensurePropertyInitialized(key);
                    return currentProperties.getProperty(key);
                }

                @Override
                public String getProperty(String key, String defaultValue) {
                    this.ensurePropertyInitialized(key);
                    return currentProperties.getProperty(key, defaultValue);
                }

                @Override
                public Enumeration<?> propertyNames() {
                    return currentProperties.propertyNames();
                }

                @Override
                public Set<String> stringPropertyNames() {
                    return currentProperties.stringPropertyNames();
                }

                @Override
                public void list(PrintStream out) {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.list(out);
                }

                @Override
                public void list(PrintWriter out) {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.list(out);
                }

                @Override
                public int size() {
                    return currentProperties.size();
                }

                @Override
                public boolean isEmpty() {
                    return currentProperties.isEmpty();
                }

                @Override
                public Enumeration<Object> keys() {
                    return currentProperties.keys();
                }

                @Override
                public Enumeration<Object> elements() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.elements();
                }

                @Override
                public boolean contains(Object value) {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.contains(value);
                }

                @Override
                public boolean containsValue(Object value) {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.containsValue(value);
                }

                @Override
                public boolean containsKey(Object key) {
                    return currentProperties.containsKey(key);
                }

                @Override
                public Object get(Object key) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.get(key);
                }

                @Override
                public synchronized Object put(Object key, Object value) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.put(key, value);
                }

                @Override
                public synchronized Object remove(Object key) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.remove(key);
                }

                @Override
                public synchronized void putAll(Map<?, ?> t) {
                    currentProperties.putAll(t);
                }

                @Override
                public synchronized void clear() {
                    currentProperties.clear();
                }

                @Override
                public synchronized String toString() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.toString();
                }

                @Override
                public Set<Object> keySet() {
                    return currentProperties.keySet();
                }

                @Override
                public Collection<Object> values() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.values();
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.entrySet();
                }

                @Override
                public synchronized boolean equals(Object o) {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.equals(o);
                }

                @Override
                public synchronized int hashCode() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.hashCode();
                }

                @Override
                public Object getOrDefault(Object key, Object defaultValue) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.getOrDefault(key, defaultValue);
                }

                @Override
                public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.forEach(action);
                }

                @Override
                public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
                    this.ensureAllPropertiesInitialized();
                    currentProperties.replaceAll(function);
                }

                @Override
                public synchronized Object putIfAbsent(Object key, Object value) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.putIfAbsent(key, value);
                }

                @Override
                public synchronized boolean remove(Object key, Object value) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.remove(key, value);
                }

                @Override
                public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.replace(key, oldValue, newValue);
                }

                @Override
                public synchronized Object replace(Object key, Object value) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.replace(key, value);
                }

                @Override
                public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.computeIfAbsent(key, mappingFunction);
                }

                @Override
                public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.computeIfPresent(key, remappingFunction);
                }

                @Override
                public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.compute(key, remappingFunction);
                }

                @Override
                public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.ensurePropertyInitialized((String)key);
                    }
                    return currentProperties.merge(key, value, remappingFunction);
                }

                @Override
                public synchronized Object clone() {
                    this.ensureAllPropertiesInitialized();
                    return currentProperties.clone();
                }
            };
        }

        private static final class SystemPropertiesSupportGetCurrentPropertiesPresent
        implements BooleanSupplier {
            private SystemPropertiesSupportGetCurrentPropertiesPresent() {
            }

            @Override
            public boolean getAsBoolean() {
                try {
                    Class<?> klass = Class.forName("com.oracle.svm.core.jdk.SystemPropertiesSupport");
                    klass.getDeclaredMethod("getCurrentProperties", new Class[0]);
                    return true;
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    return false;
                }
            }
        }
    }

    @TargetClass(className="com.oracle.svm.core.jdk.SystemPropertiesSupport", onlyWith={SystemPropertiesSupportGetPropertiesPresent.class})
    static final class Target_SystemPropertiesSupport {
        @Alias
        private Properties properties;

        Target_SystemPropertiesSupport() {
        }

        @Alias
        private void ensureFullyInitialized() {
        }

        @Alias
        private void initializeLazyValue(String key) {
        }

        @Substitute
        public Properties getProperties() {
            return new Properties(){

                @Override
                public synchronized Object setProperty(String key, String value) {
                    this.initializeLazyValue(key);
                    return properties.setProperty(key, value);
                }

                @Override
                public synchronized void load(Reader reader) throws IOException {
                    properties.load(reader);
                }

                @Override
                public synchronized void load(InputStream inStream) throws IOException {
                    properties.load(inStream);
                }

                @Override
                public void save(OutputStream out, String comments) {
                    this.ensureFullyInitialized();
                    properties.save(out, comments);
                }

                @Override
                public void store(Writer writer, String comments) throws IOException {
                    this.ensureFullyInitialized();
                    properties.store(writer, comments);
                }

                @Override
                public void store(OutputStream out, String comments) throws IOException {
                    this.ensureFullyInitialized();
                    properties.store(out, comments);
                }

                @Override
                public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
                    properties.loadFromXML(in);
                }

                @Override
                public void storeToXML(OutputStream os, String comment) throws IOException {
                    this.ensureFullyInitialized();
                    properties.storeToXML(os, comment);
                }

                @Override
                public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
                    this.ensureFullyInitialized();
                    properties.storeToXML(os, comment, encoding);
                }

                @Override
                public void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
                    this.ensureFullyInitialized();
                    properties.storeToXML(os, comment, charset);
                }

                @Override
                public String getProperty(String key) {
                    this.initializeLazyValue(key);
                    return properties.getProperty(key);
                }

                @Override
                public String getProperty(String key, String defaultValue) {
                    this.initializeLazyValue(key);
                    return properties.getProperty(key, defaultValue);
                }

                @Override
                public Enumeration<?> propertyNames() {
                    return properties.propertyNames();
                }

                @Override
                public Set<String> stringPropertyNames() {
                    return properties.stringPropertyNames();
                }

                @Override
                public void list(PrintStream out) {
                    this.ensureFullyInitialized();
                    properties.list(out);
                }

                @Override
                public void list(PrintWriter out) {
                    this.ensureFullyInitialized();
                    properties.list(out);
                }

                @Override
                public int size() {
                    return properties.size();
                }

                @Override
                public boolean isEmpty() {
                    return properties.isEmpty();
                }

                @Override
                public Enumeration<Object> keys() {
                    return properties.keys();
                }

                @Override
                public Enumeration<Object> elements() {
                    this.ensureFullyInitialized();
                    return properties.elements();
                }

                @Override
                public boolean contains(Object value) {
                    this.ensureFullyInitialized();
                    return properties.contains(value);
                }

                @Override
                public boolean containsValue(Object value) {
                    this.ensureFullyInitialized();
                    return properties.containsValue(value);
                }

                @Override
                public boolean containsKey(Object key) {
                    return properties.containsKey(key);
                }

                @Override
                public Object get(Object key) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.get(key);
                }

                @Override
                public synchronized Object put(Object key, Object value) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.put(key, value);
                }

                @Override
                public synchronized Object remove(Object key) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.remove(key);
                }

                @Override
                public synchronized void putAll(Map<?, ?> t) {
                    properties.putAll(t);
                }

                @Override
                public synchronized void clear() {
                    properties.clear();
                }

                @Override
                public synchronized String toString() {
                    this.ensureFullyInitialized();
                    return properties.toString();
                }

                @Override
                public Set<Object> keySet() {
                    return properties.keySet();
                }

                @Override
                public Collection<Object> values() {
                    this.ensureFullyInitialized();
                    return properties.values();
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    this.ensureFullyInitialized();
                    return properties.entrySet();
                }

                @Override
                public synchronized boolean equals(Object o) {
                    this.ensureFullyInitialized();
                    return properties.equals(o);
                }

                @Override
                public synchronized int hashCode() {
                    this.ensureFullyInitialized();
                    return properties.hashCode();
                }

                @Override
                public Object getOrDefault(Object key, Object defaultValue) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.getOrDefault(key, defaultValue);
                }

                @Override
                public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
                    this.ensureFullyInitialized();
                    properties.forEach(action);
                }

                @Override
                public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
                    this.ensureFullyInitialized();
                    properties.replaceAll(function);
                }

                @Override
                public synchronized Object putIfAbsent(Object key, Object value) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.putIfAbsent(key, value);
                }

                @Override
                public synchronized boolean remove(Object key, Object value) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.remove(key, value);
                }

                @Override
                public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.replace(key, oldValue, newValue);
                }

                @Override
                public synchronized Object replace(Object key, Object value) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.replace(key, value);
                }

                @Override
                public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.computeIfAbsent(key, mappingFunction);
                }

                @Override
                public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.computeIfPresent(key, remappingFunction);
                }

                @Override
                public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.compute(key, remappingFunction);
                }

                @Override
                public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
                    if (key instanceof String) {
                        this.initializeLazyValue((String)key);
                    }
                    return properties.merge(key, value, remappingFunction);
                }

                @Override
                public synchronized Object clone() {
                    this.ensureFullyInitialized();
                    return properties.clone();
                }
            };
        }

        private static final class SystemPropertiesSupportGetPropertiesPresent
        implements BooleanSupplier {
            private SystemPropertiesSupportGetPropertiesPresent() {
            }

            @Override
            public boolean getAsBoolean() {
                try {
                    Class<?> klass = Class.forName("com.oracle.svm.core.jdk.SystemPropertiesSupport");
                    klass.getDeclaredMethod("getProperties", new Class[0]);
                    return true;
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    return false;
                }
            }
        }
    }

    @TargetClass(value=ConfigMappingLoader.class, innerClass={"ConfigMappingClass"})
    static final class Target_ConfigMappingClass {
        @Alias
        static ClassValue<Target_ConfigMappingClass> cv = null;
        @Alias
        private Class<?> classType;
        @Alias
        private String interfaceName;

        @Substitute
        public static Target_ConfigMappingClass getConfigurationClass(Class<?> classType) {
            Assert.checkNotNullParam((String)"classType", classType);
            try {
                return cv.get(classType);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Substitute
        @TargetElement(name="<init>")
        public Target_ConfigMappingClass(Class<?> classType) {
            this.classType = classType;
            this.interfaceName = classType.getPackage().getName() + "." + classType.getSimpleName() + classType.getName().hashCode() + "I";
        }

        @Substitute
        public byte[] getClassBytes() {
            return null;
        }
    }

    @TargetClass(value=ConfigMappingInterface.class)
    static final class Target_ConfigMappingInterface {
        @Alias
        static ClassValue<Target_ConfigMappingInterface> cv = null;

        Target_ConfigMappingInterface() {
        }

        @Substitute
        public static Target_ConfigMappingInterface getConfigurationInterface(Class<?> interfaceType) {
            Assert.checkNotNullParam((String)"interfaceType", interfaceType);
            try {
                return cv.get(interfaceType);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Substitute
        public byte[] getClassBytes() {
            return null;
        }
    }

    @TargetClass(value=ConfigMappingLoader.class)
    static final class Target_ConfigMappingLoader {
        Target_ConfigMappingLoader() {
        }

        @Substitute
        static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
            try {
                return parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Substitute
        private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
            return null;
        }
    }

    @TargetClass(value=ConfigProviderResolver.class)
    static final class Target_ConfigurationProviderResolver {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        private static volatile ConfigProviderResolver instance;

        Target_ConfigurationProviderResolver() {
        }
    }
}

