/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.AsyncDelay;
import io.smallrye.faulttolerance.core.retry.SyncDelay;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.util.concurrent.Executor;

final class SyncDelayAsAsync
implements AsyncDelay {
    private final SyncDelay delegate;

    public SyncDelayAsAsync(SyncDelay delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "SyncDelay must be set");
    }

    @Override
    public void after(Throwable cause, Runnable task, Executor executor) {
        try {
            this.delegate.sleep(cause);
        }
        catch (InterruptedException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
        task.run();
    }
}

