/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.BulkheadConfig;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class BulkheadConfigImpl
implements BulkheadConfig {
    private final String description;
    private final String configKey;
    private final Bulkhead instance;
    private Integer _value;
    private Integer _waitingTaskQueue;

    private BulkheadConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Bulkhead.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.bulkhead;
    }

    private BulkheadConfigImpl(String id, Bulkhead instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static BulkheadConfigImpl create(FaultToleranceMethod method) {
        if (method.bulkhead == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("bulkhead.enabled", "Bulkhead/enabled", method.method)) {
            return null;
        }
        return new BulkheadConfigImpl(method);
    }

    public static BulkheadConfigImpl create(String id, Supplier<Bulkhead> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("bulkhead.enabled", "Bulkhead/enabled", id)) {
            return null;
        }
        return new BulkheadConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    public int value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".bulkhead.value";
            Object oldKey = this.configKey + "/Bulkhead/value";
            this._value = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> BulkheadConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.bulkhead.value";
                oldKey = "Bulkhead/value";
                this._value = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> BulkheadConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public int waitingTaskQueue() {
        if (this._waitingTaskQueue == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".bulkhead.waiting-task-queue";
            Object oldKey = this.configKey + "/Bulkhead/waitingTaskQueue";
            this._waitingTaskQueue = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> BulkheadConfigImpl.lambda$waitingTaskQueue$2(config, (String)oldKey)).orElse(null);
            if (this._waitingTaskQueue == null) {
                newKey = "smallrye.faulttolerance.global.bulkhead.waiting-task-queue";
                oldKey = "Bulkhead/waitingTaskQueue";
                this._waitingTaskQueue = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> BulkheadConfigImpl.lambda$waitingTaskQueue$3(config, (String)oldKey)).orElse(null);
            }
            if (this._waitingTaskQueue == null) {
                this._waitingTaskQueue = this.instance.waitingTaskQueue();
            }
        }
        return this._waitingTaskQueue;
    }

    public void materialize() {
        this.value();
        this.waitingTaskQueue();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$waitingTaskQueue$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$waitingTaskQueue$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }
}

