/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithParentName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.service.config.FeaturesConfiguration;

@ConfigMapping(prefix="polaris.behavior-changes")
public interface QuarkusBehaviorChangesConfiguration {
    @WithParentName
    public Map<String, String> defaults();

    public Map<String, ? extends QuarkusRealmOverrides> realmOverrides();

    default public Map<String, Object> parseDefaults(ObjectMapper objectMapper) {
        return QuarkusBehaviorChangesConfiguration.convertMap(objectMapper, this.defaults());
    }

    default public Map<String, Map<String, Object>> parseRealmOverrides(ObjectMapper objectMapper) {
        HashMap<String, Map<String, Object>> m = new HashMap<String, Map<String, Object>>();
        for (String realm : this.realmOverrides().keySet()) {
            m.put(realm, QuarkusBehaviorChangesConfiguration.convertMap(objectMapper, this.realmOverrides().get(realm).overrides()));
        }
        return m;
    }

    private static Map<String, Object> convertMap(ObjectMapper objectMapper, Map<String, String> properties) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String configName : properties.keySet()) {
            String json = properties.get(configName);
            try {
                JsonNode node = objectMapper.readTree(json);
                m.put(configName, QuarkusBehaviorChangesConfiguration.configValue(node));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Invalid JSON value for feature configuration: " + configName, e);
            }
        }
        return m;
    }

    private static Object configValue(JsonNode node) {
        return switch (node.getNodeType()) {
            case JsonNodeType.BOOLEAN -> node.asBoolean();
            case JsonNodeType.STRING -> node.asText();
            case JsonNodeType.NUMBER -> {
                switch (node.numberType()) {
                    case INT: 
                    case LONG: {
                        yield node.asLong();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        yield node.asDouble();
                    }
                }
                throw new IllegalArgumentException("Unsupported number type: " + String.valueOf(node.numberType()));
            }
            case JsonNodeType.ARRAY -> {
                ArrayList list = new ArrayList();
                node.elements().forEachRemaining(n -> list.add(QuarkusBehaviorChangesConfiguration.configValue(n)));
                yield List.copyOf(list);
            }
            default -> throw new IllegalArgumentException("Unsupported feature configuration JSON type: " + String.valueOf(node.getNodeType()));
        };
    }

    public static interface QuarkusRealmOverrides
    extends FeaturesConfiguration.RealmOverrides {
        @WithParentName
        public Map<String, String> overrides();
    }
}

