/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.metrics;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.internal.OnlyOnceLoggingDenyMeterFilter;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.stream.Collectors;
import org.apache.polaris.service.quarkus.metrics.QuarkusMetricsConfiguration;

public class QuarkusMeterFilterProducer {
    @Inject
    QuarkusMetricsConfiguration metricsConfiguration;
    @Inject
    HttpBinderConfiguration binderConfiguration;

    @Produces
    @Singleton
    public MeterFilter commonTagsFilter() {
        return MeterFilter.commonTags((Iterable)this.metricsConfiguration.tags().entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toSet()));
    }

    @Produces
    @Singleton
    public MeterFilter maxRealmIdTagsInHttpMetricsFilter() {
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number (%s) of '%s' tags for '%s'", this.metricsConfiguration.realmIdTag().httpMetricsMaxCardinality(), "realm_id", this.binderConfiguration.getHttpServerRequestsName()));
        return MeterFilter.maximumAllowableTags((String)this.binderConfiguration.getHttpServerRequestsName(), (String)"realm_id", (int)this.metricsConfiguration.realmIdTag().httpMetricsMaxCardinality(), (MeterFilter)denyFilter);
    }
}

