/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import org.immutables.value.Generated;

@Generated(from="StsClientProvider.StsDestination", generator="Immutables")
public final class ImmutableStsDestination
implements StsClientProvider.StsDestination {
    private final URI endpoint;
    private final String region;
    private transient int hashCode;

    private ImmutableStsDestination(Optional<? extends URI> endpoint, Optional<String> region) {
        this.endpoint = endpoint.orElse(null);
        this.region = region.orElse(null);
    }

    private ImmutableStsDestination(ImmutableStsDestination original, URI endpoint, String region) {
        this.endpoint = endpoint;
        this.region = region;
    }

    @Override
    public Optional<URI> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    @Override
    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }

    public final ImmutableStsDestination withEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "endpoint");
        if (this.endpoint == newValue) {
            return this;
        }
        return new ImmutableStsDestination(this, newValue, this.region);
    }

    public final ImmutableStsDestination withEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.endpoint == value) {
            return this;
        }
        return new ImmutableStsDestination(this, value, this.region);
    }

    public final ImmutableStsDestination withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (Objects.equals(this.region, newValue)) {
            return this;
        }
        return new ImmutableStsDestination(this, this.endpoint, newValue);
    }

    public final ImmutableStsDestination withRegion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.region, value)) {
            return this;
        }
        return new ImmutableStsDestination(this, this.endpoint, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStsDestination && this.equalsByValue((ImmutableStsDestination)another);
    }

    private boolean equalsByValue(ImmutableStsDestination another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.endpoint, another.endpoint) && Objects.equals(this.region, another.region);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.endpoint);
        h += (h << 5) + Objects.hashCode(this.region);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StsDestination").omitNullValues().add("endpoint", (Object)this.endpoint).add("region", (Object)this.region).toString();
    }

    public static ImmutableStsDestination of(Optional<? extends URI> endpoint, Optional<String> region) {
        return new ImmutableStsDestination(endpoint, region);
    }

    public static ImmutableStsDestination copyOf(StsClientProvider.StsDestination instance) {
        if (instance instanceof ImmutableStsDestination) {
            return (ImmutableStsDestination)instance;
        }
        return ImmutableStsDestination.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableStsDestination.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StsClientProvider.StsDestination", generator="Immutables")
    public static final class Builder {
        private URI endpoint;
        private String region;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StsClientProvider.StsDestination instance) {
            Optional<String> regionOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<URI> endpointOptional = instance.endpoint();
            if (endpointOptional.isPresent()) {
                this.endpoint(endpointOptional);
            }
            if ((regionOptional = instance.region()).isPresent()) {
                this.region(regionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endpoint(URI endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endpoint(Optional<? extends URI> endpoint) {
            this.endpoint = endpoint.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(Optional<String> region) {
            this.region = region.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.endpoint = null;
            this.region = null;
            return this;
        }

        public ImmutableStsDestination build() {
            return new ImmutableStsDestination(null, this.endpoint, this.region);
        }
    }
}

