/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.ViewMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcViewOperations
extends BaseViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcViewOperations.class);
    private final String catalogName;
    private final TableIdentifier viewIdentifier;
    private final FileIO fileIO;
    private final JdbcClientPool connections;
    private final Map<String, String> catalogProperties;

    protected JdbcViewOperations(JdbcClientPool dbConnPool, FileIO fileIO, String catalogName, TableIdentifier viewIdentifier, Map<String, String> catalogProperties) {
        this.catalogName = catalogName;
        this.viewIdentifier = viewIdentifier;
        this.fileIO = fileIO;
        this.connections = dbConnPool;
        this.catalogProperties = catalogProperties;
    }

    @Override
    protected void doRefresh() {
        Map<String, String> view;
        try {
            view = JdbcUtil.loadView(JdbcUtil.SchemaVersion.V1, this.connections, this.catalogName, this.viewIdentifier);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during refresh", new Object[0]);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to get view %s from catalog %s", this.viewIdentifier, this.catalogName);
        }
        if (view.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{this.viewIdentifier});
            }
            this.disableRefresh();
            return;
        }
        String newMetadataLocation = view.get("metadata_location");
        Preconditions.checkState((newMetadataLocation != null ? 1 : 0) != 0, (String)"Invalid view %s: metadata location is null", (Object)this.viewIdentifier);
        this.refreshFromMetadataLocation(newMetadataLocation);
    }

    @Override
    protected void doCommit(ViewMetadata base, ViewMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadataIfRequired(metadata);
        try {
            Map<String, String> view = JdbcUtil.loadView(JdbcUtil.SchemaVersion.V1, this.connections, this.catalogName, this.viewIdentifier);
            if (base != null) {
                this.validateMetadataLocation(view, base);
                String oldMetadataLocation = base.metadataFileLocation();
                LOG.debug("Committing existing view: {}", (Object)this.viewName());
                this.updateView(newMetadataLocation, oldMetadataLocation);
            } else {
                LOG.debug("Committing new view: {}", (Object)this.viewName());
                this.createView(newMetadataLocation);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            if (this.currentMetadataLocation() == null) {
                throw new AlreadyExistsException((Throwable)e, "View already exists: %s", new Object[]{this.viewIdentifier});
            }
            throw new UncheckedSQLException(e, "View already exists: %s", this.viewIdentifier);
        }
        catch (SQLTimeoutException e) {
            throw new UncheckedSQLException(e, "Database Connection timeout", new Object[0]);
        }
        catch (SQLNonTransientConnectionException | SQLTransientConnectionException e) {
            throw new UncheckedSQLException(e, "Database Connection failed", new Object[0]);
        }
        catch (DataTruncation e) {
            throw new UncheckedSQLException(e, "Database data truncation error", new Object[0]);
        }
        catch (SQLWarning e) {
            throw new UncheckedSQLException(e, "Database warning", new Object[0]);
        }
        catch (SQLException e) {
            if (e.getMessage() != null && e.getMessage().contains("constraint failed")) {
                throw new AlreadyExistsException("View already exists: %s", new Object[]{this.viewIdentifier});
            }
            throw new UncheckedSQLException(e, "Unknown failure", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during commit", new Object[0]);
        }
    }

    @Override
    protected String viewName() {
        return this.viewIdentifier.toString();
    }

    @Override
    protected FileIO io() {
        return this.fileIO;
    }

    private void validateMetadataLocation(Map<String, String> view, ViewMetadata base) {
        String baseMetadataLocation;
        String catalogMetadataLocation = view.get("metadata_location");
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, catalogMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s: metadata location %s has changed from %s", new Object[]{this.viewIdentifier, baseMetadataLocation, catalogMetadataLocation});
        }
    }

    private void updateView(String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        int updatedRecords = JdbcUtil.updateView(this.connections, this.catalogName, this.viewIdentifier, newMetadataLocation, oldMetadataLocation);
        if (updatedRecords != 1) {
            throw new CommitFailedException("Failed to update view %s from catalog %s", new Object[]{this.viewIdentifier, this.catalogName});
        }
        LOG.debug("Successfully committed to existing view: {}", (Object)this.viewIdentifier);
    }

    private void createView(String newMetadataLocation) throws SQLException, InterruptedException {
        Namespace namespace = this.viewIdentifier.namespace();
        if (PropertyUtil.propertyAsBoolean(this.catalogProperties, "jdbc.strict-mode", false) && !JdbcUtil.namespaceExists(this.catalogName, this.connections, namespace)) {
            throw new NoSuchNamespaceException("Cannot create view %s in catalog %s. Namespace %s does not exist", new Object[]{this.viewIdentifier, this.catalogName, namespace});
        }
        if (JdbcUtil.tableExists(JdbcUtil.SchemaVersion.V1, this.catalogName, this.connections, this.viewIdentifier)) {
            throw new AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.viewIdentifier});
        }
        if (JdbcUtil.viewExists(this.catalogName, this.connections, this.viewIdentifier)) {
            throw new AlreadyExistsException("View already exists: %s", new Object[]{this.viewIdentifier});
        }
        int insertRecord = JdbcUtil.doCommitCreateView(this.connections, this.catalogName, namespace, this.viewIdentifier, newMetadataLocation);
        if (insertRecord != 1) {
            throw new CommitFailedException("Failed to create view %s in catalog %s", new Object[]{this.viewIdentifier, this.catalogName});
        }
        LOG.debug("Successfully committed to new view: {}", (Object)this.viewIdentifier);
    }
}

