/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.AbstractCollectionCodec;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.ContainerCodecHelper;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.Parameterizable;
import org.bson.codecs.ParameterizedCollectionCodec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class CollectionCodec<C extends Collection<Object>>
extends AbstractCollectionCodec<Object, C>
implements OverridableUuidRepresentationCodec<C>,
Parameterizable {
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    CollectionCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer, Class<C> clazz) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, clazz, UuidRepresentation.UNSPECIFIED);
    }

    private CollectionCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, Class<C> clazz, UuidRepresentation uuidRepresentation) {
        super(clazz);
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<?> parameterize(CodecRegistry codecRegistry, List<Type> types) {
        if (types.size() != 1) {
            throw new CodecConfigurationException("Expected only one parameterized type for an Iterable, but found " + types.size());
        }
        return new ParameterizedCollectionCodec(ContainerCodecHelper.getCodec(codecRegistry, types.get(0)), this.getEncoderClass());
    }

    @Override
    public Codec<C> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new CollectionCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, this.getEncoderClass(), uuidRepresentation);
    }

    @Override
    Object readValue(BsonReader reader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter writer, Object value, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }
}

