/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.entities.StatData;

public class AuditUtils {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String STREAM_ID_CONDITION_PATTERN = "(?i)\\band\\s+inlong_stream_id\\s*=\\s*\\?\\s*";

    public static double calculateDiffRatio(long srcCount, long destCount) {
        if (srcCount == 0L && destCount == 0L) {
            return 0.0;
        }
        if (srcCount == 0L) {
            return 1.0;
        }
        return Math.abs((double)(srcCount - destCount) / (double)srcCount);
    }

    public static StatData getMaxAuditVersionAuditData(List<StatData> statDataListData) {
        StatData maxAuditVersionStatData = null;
        for (StatData statData : statDataListData) {
            if (maxAuditVersionStatData != null && statData.getAuditVersion() <= maxAuditVersionStatData.getAuditVersion()) continue;
            maxAuditVersionStatData = statData;
        }
        return maxAuditVersionStatData;
    }

    public static AuditCycle getAuditCycleTime(String startTime, String endTime) {
        LocalDateTime startDateTime = LocalDateTime.parse(startTime, dateTimeFormatter);
        LocalDateTime endDateTime = LocalDateTime.parse(endTime, dateTimeFormatter);
        return AuditCycle.fromInt((int)((int)ChronoUnit.MINUTES.between(startDateTime, endDateTime)));
    }

    public static StatData mergeStatDataList(List<StatData> statDataList) {
        if (statDataList == null || statDataList.isEmpty()) {
            return null;
        }
        StatData base = statDataList.get(0);
        long totalCount = 0L;
        for (StatData statData : statDataList) {
            if (statData.getCount() == null) continue;
            totalCount += statData.getCount().longValue();
        }
        StatData mergedStatData = new StatData();
        mergedStatData.setAuditVersion(base.getAuditVersion());
        mergedStatData.setLogTs(base.getLogTs());
        mergedStatData.setInlongGroupId(base.getInlongGroupId());
        mergedStatData.setInlongStreamId(base.getInlongStreamId());
        mergedStatData.setAuditId(base.getAuditId());
        mergedStatData.setAuditTag(base.getAuditTag());
        mergedStatData.setCount(Long.valueOf(totalCount));
        mergedStatData.setSize(base.getSize());
        mergedStatData.setDelay(base.getDelay());
        mergedStatData.setUpdateTime(base.getUpdateTime());
        mergedStatData.setIp(base.getIp());
        mergedStatData.setSourceName(base.getSourceName());
        return mergedStatData;
    }

    public static List<StatData> aggregateStatData(List<StatData> data, String streamId) {
        if (data == null || data.isEmpty()) {
            return new ArrayList<StatData>();
        }
        HashMap<String, StatData> aggregatedMap = new HashMap<String, StatData>(data.size());
        for (StatData stat : data) {
            StatData aggregatedStatData = aggregatedMap.computeIfAbsent(stat.getCompositeKey(), k -> new StatData(stat.getLogTs(), stat.getInlongGroupId(), streamId, stat.getAuditId()));
            aggregatedStatData.add(stat.getCount(), stat.getSize(), stat.getDelay());
        }
        return new ArrayList<StatData>(aggregatedMap.values());
    }

    public static String removeStreamIdCondition(String sqlQuery) {
        return sqlQuery == null ? null : sqlQuery.replaceAll(STREAM_ID_CONDITION_PATTERN, " ");
    }

    public static String removeStreamIdColumn(String sql) {
        if (sql == null) {
            return null;
        }
        sql = sql.replaceAll("(?i)\\b(inlong_stream_id)\\b\\s*,?\\s*", "");
        sql = sql.replaceAll(",?\\s*\\b(inlong_stream_id)\\b(?=\\s*$)", "");
        return sql;
    }
}

