/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class TimestampToTimeCastRule
extends AbstractExpressionCodeGeneratorCastRule<TimestampData, Number> {
    static final TimestampToTimeCastRule INSTANCE = new TimestampToTimeCastRule();

    private TimestampToTimeCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return CastRuleUtils.cast("int", CastRuleUtils.operator(CastRuleUtils.methodCall(inputTerm, "getMillisecond", new Object[0]), "%", 86400000L));
        }
        if (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME(), inputTerm, context.getSessionTimeZoneTerm());
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

