/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeleteStreamSourceTask
extends TimerTask
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DeleteStreamSourceTask.class);
    private static final int INITIAL_DELAY_MINUTES = 5;
    private static final int INTERVAL_MINUTES = 60;
    @Value(value="${group.deleted.enabled:false}")
    private Boolean enabled;
    @Value(value="${group.deleted.batch.size:100}")
    private Integer batchSize;
    @Value(value="${group.deleted.latest.hours:10}")
    private Integer latestHours;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;

    public void afterPropertiesSet() {
        if (this.enabled.booleanValue()) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("inlong-group-delete-%s").build();
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.AbortPolicy());
            executor.scheduleWithFixedDelay(this, 5L, 60L, TimeUnit.MINUTES);
            log.info("success to start the delete stream source task");
        }
    }

    @Override
    public void run() {
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime latestTime = currentTime.minusHours(this.latestHours.intValue()).truncatedTo(ChronoUnit.HOURS);
        Date modifyTime = Date.from(latestTime.atZone(ZoneId.systemDefault()).toInstant());
        List groupIds = this.groupMapper.selectDeletedGroupIdsWithTimeAfter(modifyTime, this.batchSize);
        if (CollectionUtils.isEmpty((Collection)groupIds)) {
            return;
        }
        this.deleteSources(groupIds);
    }

    private void deleteSources(List<String> inlongGroupIds) {
        List sourceList = this.sourceMapper.selectByGroupIds(inlongGroupIds);
        if (CollectionUtils.isEmpty((Collection)sourceList)) {
            return;
        }
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (StreamSourceEntity source : sourceList) {
            if (!SourceStatus.SOURCE_NORMAL.getCode().equals(source.getStatus()) || !StringUtils.isNotBlank((String)source.getInlongClusterNodeGroup())) continue;
            idList.add(source.getId());
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            this.sourceMapper.logicalDeleteByIds(idList, SourceStatus.TO_BE_ISSUED_DELETE.getCode());
            log.info("success to delete stream source with id in {}", idList);
        }
    }
}

