/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.util;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<E>
extends AbstractSet<E> {
    private final ConcurrentHashMap<E, Long> keyValMap = new ConcurrentHashMap();

    @Override
    public boolean add(E item) {
        Long value = this.keyValMap.putIfAbsent(item, System.currentTimeMillis());
        return value == null;
    }

    @Override
    public boolean contains(Object item) {
        return this.keyValMap.containsKey(item);
    }

    @Override
    public boolean remove(Object item) {
        return this.keyValMap.remove(item) != null;
    }

    @Override
    public void clear() {
        this.keyValMap.clear();
    }

    @Override
    public int size() {
        return this.keyValMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyValMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new HashSet(this.keyValMap.keySet()).iterator();
    }

    public Long getItemAddTime(E item) {
        return this.keyValMap.get(item);
    }
}

