/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.quartz;

import org.apache.inlong.manager.schedule.quartz.QuartzScheduleEngine;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerListener
implements SchedulerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSchedulerListener.class);
    private QuartzScheduleEngine quartzScheduleEngine;

    public QuartzSchedulerListener(QuartzScheduleEngine quartzScheduleEngine) {
        this.quartzScheduleEngine = quartzScheduleEngine;
    }

    public void jobScheduled(Trigger trigger) {
        LOGGER.info("Quartz job with key {} scheduled", (Object)trigger.getKey().getName());
    }

    public void jobUnscheduled(TriggerKey triggerKey) {
        LOGGER.info("Quartz job with key {} un-scheduled", (Object)triggerKey.getName());
    }

    public void triggerFinalized(Trigger trigger) {
        this.quartzScheduleEngine.triggerFinalized(trigger);
        LOGGER.info("Quartz trigger with key {} startTime {} ande endTime {} is finalized", new Object[]{trigger.getKey().getName(), trigger.getStartTime(), trigger.getEndTime()});
    }

    public void triggerPaused(TriggerKey triggerKey) {
        LOGGER.info("Quartz trigger with key {} paused", (Object)triggerKey.getName());
    }

    public void triggersPaused(String triggerGroup) {
    }

    public void triggerResumed(TriggerKey triggerKey) {
        LOGGER.info("Quartz trigger with key {} Resume", (Object)triggerKey.getName());
    }

    public void triggersResumed(String triggerGroup) {
    }

    public void jobAdded(JobDetail jobDetail) {
        LOGGER.info("New quartz job added, name {}", (Object)jobDetail.getKey().getName());
    }

    public void jobDeleted(JobKey jobKey) {
        LOGGER.info("Quartz job deleted, name {}", (Object)jobKey.getName());
    }

    public void jobPaused(JobKey jobKey) {
        LOGGER.info("Quartz job paused, name {}", (Object)jobKey.getName());
    }

    public void jobsPaused(String jobGroup) {
    }

    public void jobResumed(JobKey jobKey) {
        LOGGER.info("Quartz job resumed, name {}", (Object)jobKey.getName());
    }

    public void jobsResumed(String jobGroup) {
    }

    public void schedulerError(String msg, SchedulerException cause) {
        LOGGER.warn("Quartz schedule exception, errorMsg {}", (Object)msg, (Object)cause);
    }

    public void schedulerInStandbyMode() {
    }

    public void schedulerStarted() {
        LOGGER.warn("Quartz scheduler started");
    }

    public void schedulerStarting() {
        LOGGER.warn("Quartz scheduler starting");
    }

    public void schedulerShutdown() {
        LOGGER.warn("Quartz scheduler shutdown");
    }

    public void schedulerShuttingdown() {
        LOGGER.warn("Quartz scheduler shutting down");
    }

    public void schedulingDataCleared() {
        LOGGER.warn("Quartz scheduler data cleared");
    }
}

