/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.event;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;

public class JSONEvent
implements Event {
    private Map<String, String> headers;
    private String body;
    private transient String charset = "UTF-8";

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public byte[] getBody() {
        if (this.body != null) {
            try {
                return this.body.getBytes(this.charset);
            }
            catch (UnsupportedEncodingException ex) {
                throw new FlumeException(String.format("%s encoding not supported", this.charset), ex);
            }
        }
        return new byte[0];
    }

    @Override
    public void setBody(byte[] body) {
        this.body = body != null ? new String(body) : "";
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

