/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.bounded.Boundaries;
import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="pulsarExtract")
public class PulsarExtractNode
extends ExtractNode
implements InlongMetric,
Metadata {
    private static final Logger log = LoggerFactory.getLogger(PulsarExtractNode.class);
    private static final long serialVersionUID = 1L;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="adminUrl")
    private String adminUrl;
    @Nonnull
    @JsonProperty(value="serviceUrl")
    private String serviceUrl;
    @Nonnull
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="scanStartupMode")
    private String scanStartupMode;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="scanStartupSubName")
    private String scanStartupSubName;
    @JsonProperty(value="scanStartupSubStartOffset")
    private String scanStartupSubStartOffset;
    @JsonProperty(value="clientAuthPluginClassName")
    private String clientAuthPluginClassName;
    @JsonProperty(value="clientAuthParams")
    private String clientAuthParams;
    Map<String, String> sourceBoundaryOptions = new HashMap<String, String>();

    @JsonCreator
    public PulsarExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="topic") String topic, @JsonProperty(value="adminUrl") String adminUrl, @Nonnull @JsonProperty(value="serviceUrl") String serviceUrl, @Nonnull @JsonProperty(value="format") Format format, @JsonProperty(value="scanStartupMode") String scanStartupMode, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="scanStartupSubName") String scanStartupSubName, @JsonProperty(value="scanStartupSubStartOffset") String scanStartupSubStartOffset, @JsonProperty(value="clientAuthPluginClassName") String clientAuthPluginClassName, @JsonProperty(value="clientAuthParams") String clientAuthParams) {
        super(id, name, fields, watermarkField, properties);
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"pulsar topic is null.");
        this.serviceUrl = (String)Preconditions.checkNotNull((Object)serviceUrl, (Object)"pulsar serviceUrl is null.");
        this.format = (Format)Preconditions.checkNotNull((Object)format, (Object)"pulsar format is null.");
        this.scanStartupMode = scanStartupMode;
        this.adminUrl = adminUrl;
        this.primaryKey = primaryKey;
        this.scanStartupSubName = scanStartupSubName;
        this.scanStartupSubStartOffset = scanStartupSubStartOffset;
        this.clientAuthPluginClassName = clientAuthPluginClassName;
        this.clientAuthParams = clientAuthParams;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        if (StringUtils.isBlank((CharSequence)this.primaryKey)) {
            options.put("connector", "pulsar-inlong");
            options.putAll(this.format.generateOptions(false));
        } else {
            options.put("connector", "upsert-pulsar-inlong");
            options.putAll(this.format.generateOptions(true));
        }
        if (StringUtils.isNotBlank((CharSequence)this.adminUrl)) {
            options.put("admin-url", this.adminUrl);
        }
        options.put("service-url", this.serviceUrl);
        options.put("topic", this.topic);
        if (StringUtils.isNotBlank((CharSequence)this.scanStartupMode)) {
            options.put("scan.startup.mode", this.scanStartupMode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.scanStartupSubName)) {
            options.put("scan.startup.sub-name", this.scanStartupSubName);
            if (StringUtils.isNotBlank((CharSequence)this.scanStartupSubStartOffset)) {
                options.put("scan.startup.sub-start-offset", this.scanStartupSubStartOffset);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientAuthPluginClassName) && StringUtils.isNotBlank((CharSequence)this.clientAuthParams)) {
            options.put("pulsar.client.authPluginClassName", this.clientAuthPluginClassName);
            options.put("pulsar.client.authParams", this.clientAuthParams);
        }
        if (!this.sourceBoundaryOptions.isEmpty()) {
            options.putAll(this.sourceBoundaryOptions);
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case AUDIT_DATA_TIME: {
                if (this.format instanceof InLongMsgFormat) {
                    metadataKey = "value.data-time";
                    break;
                }
                metadataKey = "consume_time";
                break;
            }
            case INLONG_PROPERTIES: {
                metadataKey = "value.inlong-msg-properties";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.AUDIT_DATA_TIME, MetaField.INLONG_PROPERTIES);
    }

    @Override
    public void fillInBoundaries(Boundaries boundaries) {
        super.fillInBoundaries(boundaries);
        BoundaryType boundaryType = boundaries.getBoundaryType();
        String lowerBoundary = boundaries.getLowerBound();
        String upperBoundary = boundaries.getUpperBound();
        if (Objects.requireNonNull(boundaryType) == BoundaryType.TIME) {
            this.sourceBoundaryOptions.put("source.start.publish-time", lowerBoundary);
            this.sourceBoundaryOptions.put("source.stop.at-publish-time", upperBoundary);
            log.info("Filled in source boundaries options");
        } else {
            log.warn("Not supported boundary type: {}", (Object)boundaryType);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarExtractNode)) {
            return false;
        }
        PulsarExtractNode other = (PulsarExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$scanStartupSubName = this.getScanStartupSubName();
        String other$scanStartupSubName = other.getScanStartupSubName();
        if (this$scanStartupSubName == null ? other$scanStartupSubName != null : !this$scanStartupSubName.equals(other$scanStartupSubName)) {
            return false;
        }
        String this$scanStartupSubStartOffset = this.getScanStartupSubStartOffset();
        String other$scanStartupSubStartOffset = other.getScanStartupSubStartOffset();
        if (this$scanStartupSubStartOffset == null ? other$scanStartupSubStartOffset != null : !this$scanStartupSubStartOffset.equals(other$scanStartupSubStartOffset)) {
            return false;
        }
        String this$clientAuthPluginClassName = this.getClientAuthPluginClassName();
        String other$clientAuthPluginClassName = other.getClientAuthPluginClassName();
        if (this$clientAuthPluginClassName == null ? other$clientAuthPluginClassName != null : !this$clientAuthPluginClassName.equals(other$clientAuthPluginClassName)) {
            return false;
        }
        String this$clientAuthParams = this.getClientAuthParams();
        String other$clientAuthParams = other.getClientAuthParams();
        if (this$clientAuthParams == null ? other$clientAuthParams != null : !this$clientAuthParams.equals(other$clientAuthParams)) {
            return false;
        }
        Map<String, String> this$sourceBoundaryOptions = this.getSourceBoundaryOptions();
        Map<String, String> other$sourceBoundaryOptions = other.getSourceBoundaryOptions();
        return !(this$sourceBoundaryOptions == null ? other$sourceBoundaryOptions != null : !((Object)this$sourceBoundaryOptions).equals(other$sourceBoundaryOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $scanStartupSubName = this.getScanStartupSubName();
        result = result * 59 + ($scanStartupSubName == null ? 43 : $scanStartupSubName.hashCode());
        String $scanStartupSubStartOffset = this.getScanStartupSubStartOffset();
        result = result * 59 + ($scanStartupSubStartOffset == null ? 43 : $scanStartupSubStartOffset.hashCode());
        String $clientAuthPluginClassName = this.getClientAuthPluginClassName();
        result = result * 59 + ($clientAuthPluginClassName == null ? 43 : $clientAuthPluginClassName.hashCode());
        String $clientAuthParams = this.getClientAuthParams();
        result = result * 59 + ($clientAuthParams == null ? 43 : $clientAuthParams.hashCode());
        Map<String, String> $sourceBoundaryOptions = this.getSourceBoundaryOptions();
        result = result * 59 + ($sourceBoundaryOptions == null ? 43 : ((Object)$sourceBoundaryOptions).hashCode());
        return result;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    @Nonnull
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getScanStartupSubName() {
        return this.scanStartupSubName;
    }

    public String getScanStartupSubStartOffset() {
        return this.scanStartupSubStartOffset;
    }

    public String getClientAuthPluginClassName() {
        return this.clientAuthPluginClassName;
    }

    public String getClientAuthParams() {
        return this.clientAuthParams;
    }

    public Map<String, String> getSourceBoundaryOptions() {
        return this.sourceBoundaryOptions;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(@Nonnull String serviceUrl) {
        if (serviceUrl == null) {
            throw new NullPointerException("serviceUrl is marked non-null but is null");
        }
        this.serviceUrl = serviceUrl;
    }

    public void setFormat(@Nonnull Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setScanStartupSubName(String scanStartupSubName) {
        this.scanStartupSubName = scanStartupSubName;
    }

    public void setScanStartupSubStartOffset(String scanStartupSubStartOffset) {
        this.scanStartupSubStartOffset = scanStartupSubStartOffset;
    }

    public void setClientAuthPluginClassName(String clientAuthPluginClassName) {
        this.clientAuthPluginClassName = clientAuthPluginClassName;
    }

    public void setClientAuthParams(String clientAuthParams) {
        this.clientAuthParams = clientAuthParams;
    }

    public void setSourceBoundaryOptions(Map<String, String> sourceBoundaryOptions) {
        this.sourceBoundaryOptions = sourceBoundaryOptions;
    }

    @Override
    public String toString() {
        return "PulsarExtractNode(topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", format=" + this.getFormat() + ", scanStartupMode=" + this.getScanStartupMode() + ", primaryKey=" + this.getPrimaryKey() + ", scanStartupSubName=" + this.getScanStartupSubName() + ", scanStartupSubStartOffset=" + this.getScanStartupSubStartOffset() + ", clientAuthPluginClassName=" + this.getClientAuthPluginClassName() + ", clientAuthParams=" + this.getClientAuthParams() + ", sourceBoundaryOptions=" + this.getSourceBoundaryOptions() + ")";
    }
}

