/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractNodeProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ExtractNodeProviderFactory.class);
    @Autowired
    private List<ExtractNodeProvider> extractNodeProviderList = new ArrayList<ExtractNodeProvider>();

    public ExtractNodeProvider getExtractNodeProvider(String sourceType) {
        return this.extractNodeProviderList.stream().filter(inst -> inst.accept(sourceType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT.getMessage(), sourceType)));
    }
}

