/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Data add task request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sourceType")
public class DataAddTaskRequest {
    @ApiModelProperty(value="Group Id")
    @NotBlank(message="inlongGroupId cannot be blank")
    private @NotBlank(message="inlongGroupId cannot be blank") String groupId;
    @ApiModelProperty(value="Source ID, When the source ID is not null, data add task entries based on the source ID")
    private Integer sourceId;
    @ApiModelProperty(value="Agent ip List")
    private List<String> agentIpList;
    @ApiModelProperty(value="Source type, including: FILE, KAFKA, etc.")
    @NotBlank(message="sourceType cannot be blank")
    @Length(min=1, max=20, message="length must be between 1 and 20")
    private @NotBlank(message="sourceType cannot be blank") @Length(min=1, max=20, message="length must be between 1 and 20") String sourceType;
    @ApiModelProperty(value="Audit version", hidden=true)
    private String auditVersion;
    @ApiModelProperty(value="Data start time")
    private String dataTimeFrom;
    @ApiModelProperty(value="Data end time")
    private String dataTimeTo;
    @ApiModelProperty(value="Increase Audit Version")
    @NotNull(message="IncreaseAuditVersion cannot be null")
    private @NotNull(message="IncreaseAuditVersion cannot be null") Boolean increaseAuditVersion;

    public String getGroupId() {
        return this.groupId;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public List<String> getAgentIpList() {
        return this.agentIpList;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getAuditVersion() {
        return this.auditVersion;
    }

    public String getDataTimeFrom() {
        return this.dataTimeFrom;
    }

    public String getDataTimeTo() {
        return this.dataTimeTo;
    }

    public Boolean getIncreaseAuditVersion() {
        return this.increaseAuditVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public void setAgentIpList(List<String> agentIpList) {
        this.agentIpList = agentIpList;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setAuditVersion(String auditVersion) {
        this.auditVersion = auditVersion;
    }

    public void setDataTimeFrom(String dataTimeFrom) {
        this.dataTimeFrom = dataTimeFrom;
    }

    public void setDataTimeTo(String dataTimeTo) {
        this.dataTimeTo = dataTimeTo;
    }

    public void setIncreaseAuditVersion(Boolean increaseAuditVersion) {
        this.increaseAuditVersion = increaseAuditVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataAddTaskRequest)) {
            return false;
        }
        DataAddTaskRequest other = (DataAddTaskRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sourceId = this.getSourceId();
        Integer other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        Boolean this$increaseAuditVersion = this.getIncreaseAuditVersion();
        Boolean other$increaseAuditVersion = other.getIncreaseAuditVersion();
        if (this$increaseAuditVersion == null ? other$increaseAuditVersion != null : !((Object)this$increaseAuditVersion).equals(other$increaseAuditVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<String> this$agentIpList = this.getAgentIpList();
        List<String> other$agentIpList = other.getAgentIpList();
        if (this$agentIpList == null ? other$agentIpList != null : !((Object)this$agentIpList).equals(other$agentIpList)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$auditVersion = this.getAuditVersion();
        String other$auditVersion = other.getAuditVersion();
        if (this$auditVersion == null ? other$auditVersion != null : !this$auditVersion.equals(other$auditVersion)) {
            return false;
        }
        String this$dataTimeFrom = this.getDataTimeFrom();
        String other$dataTimeFrom = other.getDataTimeFrom();
        if (this$dataTimeFrom == null ? other$dataTimeFrom != null : !this$dataTimeFrom.equals(other$dataTimeFrom)) {
            return false;
        }
        String this$dataTimeTo = this.getDataTimeTo();
        String other$dataTimeTo = other.getDataTimeTo();
        return !(this$dataTimeTo == null ? other$dataTimeTo != null : !this$dataTimeTo.equals(other$dataTimeTo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataAddTaskRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        Boolean $increaseAuditVersion = this.getIncreaseAuditVersion();
        result = result * 59 + ($increaseAuditVersion == null ? 43 : ((Object)$increaseAuditVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<String> $agentIpList = this.getAgentIpList();
        result = result * 59 + ($agentIpList == null ? 43 : ((Object)$agentIpList).hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $auditVersion = this.getAuditVersion();
        result = result * 59 + ($auditVersion == null ? 43 : $auditVersion.hashCode());
        String $dataTimeFrom = this.getDataTimeFrom();
        result = result * 59 + ($dataTimeFrom == null ? 43 : $dataTimeFrom.hashCode());
        String $dataTimeTo = this.getDataTimeTo();
        result = result * 59 + ($dataTimeTo == null ? 43 : $dataTimeTo.hashCode());
        return result;
    }

    public String toString() {
        return "DataAddTaskRequest(groupId=" + this.getGroupId() + ", sourceId=" + this.getSourceId() + ", agentIpList=" + this.getAgentIpList() + ", sourceType=" + this.getSourceType() + ", auditVersion=" + this.getAuditVersion() + ", dataTimeFrom=" + this.getDataTimeFrom() + ", dataTimeTo=" + this.getDataTimeTo() + ", increaseAuditVersion=" + this.getIncreaseAuditVersion() + ")";
    }
}

