/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.VirtualFieldInstalledMarker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import java.util.Arrays;

public final class VirtualFieldDetector {
    private static final Cache<Class<?>, Boolean> classesWithVirtualFields = Cache.weak();

    private VirtualFieldDetector() {
    }

    public static boolean hasVirtualFields(Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (Arrays.asList(interfaces).contains(VirtualFieldInstalledMarker.class)) {
            return true;
        }
        return classesWithVirtualFields.get(clazz) != null;
    }

    public static void markVirtualFieldsPresent(Class<?> clazz) {
        classesWithVirtualFields.put(clazz, Boolean.TRUE);
    }
}

