/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetInputFile
implements InputFile {
    private final FSDataInputStream inputStream;
    private final long length;

    public ParquetInputFile(FSDataInputStream inputStream, long length) {
        this.inputStream = inputStream;
        this.length = length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public SeekableInputStream newStream() {
        return new FSDataInputStreamAdapter(this.inputStream);
    }

    private static class FSDataInputStreamAdapter
    extends DelegatingSeekableInputStream {
        private final FSDataInputStream inputStream;

        private FSDataInputStreamAdapter(FSDataInputStream inputStream) {
            super((InputStream)inputStream);
            this.inputStream = inputStream;
        }

        @Override
        public long getPos() throws IOException {
            return this.inputStream.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.inputStream.seek(newPos);
        }
    }
}

