/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatUtils;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.FormatDescriptor;

public abstract class TextFormatDescriptor<T extends TextFormatDescriptor>
extends FormatDescriptor {
    protected final DescriptorProperties internalProperties = new DescriptorProperties(true);
    protected final List<String> fieldNames = new ArrayList<String>();
    protected final List<FormatInfo> fieldFormatInfos = new ArrayList<FormatInfo>();

    protected TextFormatDescriptor(String type, int version) {
        super(type, version);
    }

    public T field(String fieldName, FormatInfo fieldFormatInfo) {
        Preconditions.checkNotNull((Object)fieldName);
        Preconditions.checkNotNull((Object)fieldFormatInfo);
        this.checkNotDuplicated(fieldName);
        this.fieldNames.add(fieldName);
        this.fieldFormatInfos.add(fieldFormatInfo);
        return (T)this;
    }

    public T schema(RowFormatInfo format) {
        Preconditions.checkNotNull((Object)format);
        this.internalProperties.putString("format.schema", FormatUtils.marshall(format));
        return (T)this;
    }

    @Deprecated
    public T schema(String schema) {
        Preconditions.checkNotNull((Object)schema);
        this.internalProperties.putString("format.schema", schema);
        return (T)this;
    }

    public T deriveSchema() {
        this.internalProperties.putBoolean("format.derive-schema", true);
        return (T)this;
    }

    public T charset(Charset charset) {
        Preconditions.checkNotNull((Object)charset);
        this.internalProperties.putString("format.charset", charset.name());
        return (T)this;
    }

    public T escapeCharacter(char escapeCharacter) {
        this.internalProperties.putCharacter("format.escape-character", escapeCharacter);
        return (T)this;
    }

    public T quoteCharacter(char quoteCharacter) {
        this.internalProperties.putCharacter("format.quote-character", quoteCharacter);
        return (T)this;
    }

    public T nullLiteral(String nullLiteral) {
        Preconditions.checkNotNull((Object)nullLiteral);
        this.internalProperties.putString("format.null-literal", nullLiteral);
        return (T)this;
    }

    public T ignoreErrors() {
        this.internalProperties.putBoolean("format.ignore-errors", true);
        return (T)this;
    }

    @Override
    public Map<String, String> toFormatProperties() {
        if (!this.fieldNames.isEmpty()) {
            RowFormatInfo formatInfo = new RowFormatInfo(this.fieldNames.toArray(new String[0]), this.fieldFormatInfos.toArray(new FormatInfo[0]));
            String schema = FormatUtils.marshall(formatInfo);
            this.internalProperties.putString("format.schema", schema);
        }
        return this.internalProperties.asMap();
    }

    private void checkNotDuplicated(String newFieldName) {
        if (this.fieldNames.contains(newFieldName)) {
            throw new IllegalArgumentException("Field " + newFieldName + " already exists.");
        }
    }
}

