/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.fileSystem.FSFactoryProducer;

public class TsFileResourcePrinter {
    public static void main(String[] args) throws IOException {
        File folderFile;
        String folder = "data/data/sequence/root.group_1/0";
        if (args.length >= 1) {
            folder = args[0];
        }
        if ((folderFile = SystemFileFactory.INSTANCE.getFile(folder)).isDirectory()) {
            File[] files = FSFactoryProducer.getFSFactory().listFilesBySuffix(folderFile.getAbsolutePath(), ".tsfile.resource");
            Arrays.sort(files, Comparator.comparingLong(x -> Long.valueOf(x.getName().split("-")[0])));
            for (File file : files) {
                TsFileResourcePrinter.printResource(file.getAbsolutePath());
            }
            System.out.println("Analyzing the resource file folder " + folder + " finished.");
        } else {
            TsFileResourcePrinter.printResource(folderFile.getAbsolutePath());
            System.out.println("Analyzing the resource file " + folder + " finished.");
        }
    }

    public static void printResource(String filename) throws IOException {
        filename = filename.substring(0, filename.length() - 9);
        TsFileResource resource = new TsFileResource(SystemFileFactory.INSTANCE.getFile(filename));
        System.out.printf("Analyzing %s ...%n", filename);
        System.out.println();
        resource.deserialize();
        System.out.printf("Resource plan index range [%d, %d]%n", resource.getMinPlanIndex(), resource.getMaxPlanIndex());
        for (IDeviceID device : resource.getDevices()) {
            System.out.printf("device %s, start time %d (%s), end time %d (%s)%n", device, resource.getStartTime(device).get(), DateTimeUtils.convertLongToDate(resource.getStartTime(device).get()), resource.getEndTime(device).get(), DateTimeUtils.convertLongToDate(resource.getEndTime(device).get()));
        }
        System.out.println();
    }
}

