/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryStatistics;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.file.metadata.IDeviceID;

public class QueryContext {
    private QueryStatistics queryStatistics = new QueryStatistics();
    protected Map<TsFileID, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>> fileModCache = new ConcurrentHashMap<TsFileID, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>>();
    protected AtomicLong cachedModEntriesSize = new AtomicLong(0L);
    protected long queryId;
    private boolean debug;
    private long startTime;
    private long timeout;
    private volatile boolean isInterrupted = false;
    protected Set<TsFileID> nonExistentModFiles = new CopyOnWriteArraySet<TsFileID>();
    protected final Set<TVList> tvListSet = new HashSet<TVList>();

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    protected boolean checkIfModificationExists(TsFileResource tsFileResource) {
        if (this.nonExistentModFiles.contains(tsFileResource.getTsFileID())) {
            return false;
        }
        ModificationFile modFile = tsFileResource.getModFile();
        if (!modFile.exists()) {
            this.nonExistentModFiles.add(tsFileResource.getTsFileID());
            return false;
        }
        return true;
    }

    protected PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> getAllModifications(TsFileResource resource) {
        return this.fileModCache.computeIfAbsent(resource.getTsFileID(), k -> this.loadAllModificationsFromDisk(resource));
    }

    public PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> loadAllModificationsFromDisk(TsFileResource resource) {
        PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications = PatternTreeMapFactory.getModsPatternTreeMap();
        Iterable<Modification> modEntryIterator = resource.getModFile().getModificationsIter();
        for (Modification modification : modEntryIterator) {
            modifications.append(modification.getPath(), (Object)modification);
        }
        return modifications;
    }

    public List<Modification> getPathModifications(TsFileResource tsFileResource, IDeviceID deviceID, String measurement) throws IllegalPathException {
        if (!this.checkIfModificationExists(tsFileResource)) {
            return Collections.emptyList();
        }
        return ModificationFile.sortAndMerge(this.getAllModifications(tsFileResource).getOverlapped(new PartialPath(deviceID, measurement)));
    }

    public List<Modification> getPathModifications(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> fileMods, IDeviceID deviceID) throws IllegalPathException {
        if (fileMods == null) {
            return Collections.emptyList();
        }
        return ModificationFile.sortAndMerge(fileMods.getOverlapped((PartialPath)new PartialPath(deviceID).concatAsMeasurementPath("")));
    }

    public List<Modification> getPathModifications(TsFileResource tsFileResource, PartialPath path) {
        if (!this.checkIfModificationExists(tsFileResource)) {
            return Collections.emptyList();
        }
        return this.getPathModifications(this.getAllModifications(tsFileResource), path);
    }

    public List<Modification> getPathModifications(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> fileMods, PartialPath path) {
        if (fileMods == null) {
            return Collections.emptyList();
        }
        return ModificationFile.sortAndMerge(fileMods.getOverlapped(path));
    }

    public List<List<Modification>> getPathModifications(TsFileResource tsFileResource, AlignedPath path) {
        int n = path.getMeasurementList().size();
        ArrayList<List<Modification>> ans = new ArrayList<List<Modification>>(n);
        for (int i = 0; i < n; ++i) {
            ans.add(this.getPathModifications(tsFileResource, path.getPathWithMeasurement(i)));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public QueryStatistics getQueryStatistics() {
        return this.queryStatistics;
    }

    public void setQueryStatistics(QueryStatistics queryStatistics) {
        this.queryStatistics = queryStatistics;
    }

    public void addTVListToSet(Map<TVList, Integer> tvListMap) {
        this.tvListSet.addAll(tvListMap.keySet());
    }
}

